<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EndTransaction Structs
 * Meta informations extracted from the WSDL
 * - documentation: "EndTransaction" is used to end the transaction and finalize the record.
 * @subpackage Structs
 */
class EndTransaction extends AbstractStructBase
{
    /**
     * The Source
     * @var \Sabre\AirTicket\Structs\Source
     */
    public $Source;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\Email
     */
    public $Email;
    /**
     * Constructor method for EndTransaction
     * @uses EndTransaction::setSource()
     * @uses EndTransaction::setEmail()
     * @param \Sabre\AirTicket\Structs\Source $source
     * @param \Sabre\AirTicket\Structs\Email $email
     */
    public function __construct(\Sabre\AirTicket\Structs\Source $source = null, \Sabre\AirTicket\Structs\Email $email = null)
    {
        $this
            ->setSource($source)
            ->setEmail($email);
    }
    /**
     * Get Source value
     * @return \Sabre\AirTicket\Structs\Source|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param \Sabre\AirTicket\Structs\Source $source
     * @return \Sabre\AirTicket\Structs\EndTransaction
     */
    public function setSource(\Sabre\AirTicket\Structs\Source $source = null)
    {
        $this->Source = $source;
        return $this;
    }
    /**
     * Get Email value
     * @return \Sabre\AirTicket\Structs\Email|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \Sabre\AirTicket\Structs\Email $email
     * @return \Sabre\AirTicket\Structs\EndTransaction
     */
    public function setEmail(\Sabre\AirTicket\Structs\Email $email = null)
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\EndTransaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
