<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Email Structs
 * Meta informations extracted from the WSDL
 * - documentation: "Email" is used to send an email notification upon end transaction to any email addresses contained within the particular record.
 * @subpackage Structs
 */
class Email extends AbstractStructBase
{
    /**
     * The Ind
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Ind;
    /**
     * The eTicket
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\ETicket
     */
    public $eTicket;
    /**
     * The Invoice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\Invoice
     */
    public $Invoice;
    /**
     * The Itinerary
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\Itinerary
     */
    public $Itinerary;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\PersonName
     */
    public $PersonName;
    /**
     * Constructor method for Email
     * @uses Email::setInd()
     * @uses Email::setETicket()
     * @uses Email::setInvoice()
     * @uses Email::setItinerary()
     * @uses Email::setPersonName()
     * @param bool $ind
     * @param \Sabre\AirTicket\Structs\ETicket $eTicket
     * @param \Sabre\AirTicket\Structs\Invoice $invoice
     * @param \Sabre\AirTicket\Structs\Itinerary $itinerary
     * @param \Sabre\AirTicket\Structs\PersonName $personName
     */
    public function __construct($ind = null, \Sabre\AirTicket\Structs\ETicket $eTicket = null, \Sabre\AirTicket\Structs\Invoice $invoice = null, \Sabre\AirTicket\Structs\Itinerary $itinerary = null, \Sabre\AirTicket\Structs\PersonName $personName = null)
    {
        $this
            ->setInd($ind)
            ->setETicket($eTicket)
            ->setInvoice($invoice)
            ->setItinerary($itinerary)
            ->setPersonName($personName);
    }
    /**
     * Get Ind value
     * @return bool
     */
    public function getInd()
    {
        return $this->Ind;
    }
    /**
     * Set Ind value
     * @param bool $ind
     * @return \Sabre\AirTicket\Structs\Email
     */
    public function setInd($ind = null)
    {
        $this->Ind = $ind;
        return $this;
    }
    /**
     * Get eTicket value
     * @return \Sabre\AirTicket\Structs\ETicket|null
     */
    public function getETicket()
    {
        return $this->eTicket;
    }
    /**
     * Set eTicket value
     * @param \Sabre\AirTicket\Structs\ETicket $eTicket
     * @return \Sabre\AirTicket\Structs\Email
     */
    public function setETicket(\Sabre\AirTicket\Structs\ETicket $eTicket = null)
    {
        $this->eTicket = $eTicket;
        return $this;
    }
    /**
     * Get Invoice value
     * @return \Sabre\AirTicket\Structs\Invoice|null
     */
    public function getInvoice()
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param \Sabre\AirTicket\Structs\Invoice $invoice
     * @return \Sabre\AirTicket\Structs\Email
     */
    public function setInvoice(\Sabre\AirTicket\Structs\Invoice $invoice = null)
    {
        $this->Invoice = $invoice;
        return $this;
    }
    /**
     * Get Itinerary value
     * @return \Sabre\AirTicket\Structs\Itinerary|null
     */
    public function getItinerary()
    {
        return $this->Itinerary;
    }
    /**
     * Set Itinerary value
     * @param \Sabre\AirTicket\Structs\Itinerary $itinerary
     * @return \Sabre\AirTicket\Structs\Email
     */
    public function setItinerary(\Sabre\AirTicket\Structs\Itinerary $itinerary = null)
    {
        $this->Itinerary = $itinerary;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\AirTicket\Structs\PersonName|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \Sabre\AirTicket\Structs\PersonName $personName
     * @return \Sabre\AirTicket\Structs\Email
     */
    public function setPersonName(\Sabre\AirTicket\Structs\PersonName $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\Email
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
