<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTicketRS Structs
 * @subpackage Structs
 */
class AirTicketRS extends STL_Response_Payload
{
    /**
     * The TicketInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\TicketInfo[]
     */
    public $TicketInfo;
    /**
     * Constructor method for AirTicketRS
     * @uses AirTicketRS::setTicketInfo()
     * @param \Sabre\AirTicket\Structs\TicketInfo[] $ticketInfo
     */
    public function __construct(array $ticketInfo = array())
    {
        $this
            ->setTicketInfo($ticketInfo);
    }
    /**
     * Get TicketInfo value
     * @return \Sabre\AirTicket\Structs\TicketInfo[]|null
     */
    public function getTicketInfo()
    {
        return $this->TicketInfo;
    }
    /**
     * Set TicketInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\TicketInfo[] $ticketInfo
     * @return \Sabre\AirTicket\Structs\AirTicketRS
     */
    public function setTicketInfo(array $ticketInfo = array())
    {
        $this->TicketInfo = $ticketInfo;
        return $this;
    }
    /**
     * Add item to TicketInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\TicketInfo $item
     * @return \Sabre\AirTicket\Structs\AirTicketRS
     */
    public function addToTicketInfo(\Sabre\AirTicket\Structs\TicketInfo $item)
    {
        $this->TicketInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\AirTicketRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
