<?php

namespace Sabre\AirTicket\Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Air Services
 * @subpackage Services
 */
class Air extends AbstractSoapClientBase
{
    /**
     * Sets the MessageHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Sabre\AirTicket\Structs\MessageHeader $messageHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderMessageHeader(\Sabre\AirTicket\Structs\MessageHeader $messageHeader, $nameSpace = 'http://www.ebxml.org/namespaces/messageHeader', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'MessageHeader', $messageHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the Security SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Sabre\AirTicket\Structs\Security $security
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSecurity(\Sabre\AirTicket\Structs\Security $security, $nameSpace = 'http://schemas.xmlsoap.org/ws/2002/12/secext', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Security', $security, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named AirTicketRQ
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: MessageHeader, Security
     * - SOAPHeaderNamespaces: http://www.ebxml.org/namespaces/messageHeader, http://schemas.xmlsoap.org/ws/2002/12/secext
     * - SOAPHeaderTypes: \Sabre\AirTicket\Structs\MessageHeader, \Sabre\AirTicket\Structs\Security
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sabre\AirTicket\Structs\AirTicketRQ $body
     * @return \Sabre\AirTicket\Structs\AirTicketRS|bool
     */
    public function AirTicketRQ(\Sabre\AirTicket\Structs\AirTicketRQ $body)
    {
        try {
            $this->setResult(self::getSoapClient()->AirTicketRQ($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Sabre\AirTicket\Structs\AirTicketRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
