<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidityDates Structs
 * Meta informations extracted from the WSDL
 * - documentation: This node is used to specify ticket validity dates.Cannot combine with PhaseIV.
 * @subpackage Structs
 */
class ValidityDates extends AbstractStructBase
{
    /**
     * The NotValidAfter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $NotValidAfter;
    /**
     * The NotValidBefore
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $NotValidBefore;
    /**
     * The Segment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\AirTicket\Structs\Segment[]
     */
    public $Segment;
    /**
     * Constructor method for ValidityDates
     * @uses ValidityDates::setNotValidAfter()
     * @uses ValidityDates::setNotValidBefore()
     * @uses ValidityDates::setSegment()
     * @param string $notValidAfter
     * @param string $notValidBefore
     * @param \Sabre\AirTicket\Structs\Segment[] $segment
     */
    public function __construct($notValidAfter = null, $notValidBefore = null, array $segment = array())
    {
        $this
            ->setNotValidAfter($notValidAfter)
            ->setNotValidBefore($notValidBefore)
            ->setSegment($segment);
    }
    /**
     * Get NotValidAfter value
     * @return string|null
     */
    public function getNotValidAfter()
    {
        return $this->NotValidAfter;
    }
    /**
     * Set NotValidAfter value
     * @param string $notValidAfter
     * @return \Sabre\AirTicket\Structs\ValidityDates
     */
    public function setNotValidAfter($notValidAfter = null)
    {
        $this->NotValidAfter = $notValidAfter;
        return $this;
    }
    /**
     * Get NotValidBefore value
     * @return string|null
     */
    public function getNotValidBefore()
    {
        return $this->NotValidBefore;
    }
    /**
     * Set NotValidBefore value
     * @param string $notValidBefore
     * @return \Sabre\AirTicket\Structs\ValidityDates
     */
    public function setNotValidBefore($notValidBefore = null)
    {
        $this->NotValidBefore = $notValidBefore;
        return $this;
    }
    /**
     * Get Segment value
     * @return \Sabre\AirTicket\Structs\Segment[]|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\Segment[] $segment
     * @return \Sabre\AirTicket\Structs\ValidityDates
     */
    public function setSegment(array $segment = array())
    {
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Add item to Segment value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\Segment $item
     * @return \Sabre\AirTicket\Structs\ValidityDates
     */
    public function addToSegment(\Sabre\AirTicket\Structs\Segment $item)
    {
        $this->Segment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\ValidityDates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
