<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransformsType Structs
 * @subpackage Structs
 */
class TransformsType extends AbstractStructBase
{
    /**
     * The Transform
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ds:Transform
     * @var \Sabre\AirTicket\Structs\TransformType[]
     */
    public $Transform;
    /**
     * Constructor method for TransformsType
     * @uses TransformsType::setTransform()
     * @param \Sabre\AirTicket\Structs\TransformType[] $transform
     */
    public function __construct(array $transform = array())
    {
        $this
            ->setTransform($transform);
    }
    /**
     * Get Transform value
     * @return \Sabre\AirTicket\Structs\TransformType[]|null
     */
    public function getTransform()
    {
        return $this->Transform;
    }
    /**
     * Set Transform value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\TransformType[] $transform
     * @return \Sabre\AirTicket\Structs\TransformsType
     */
    public function setTransform(array $transform = array())
    {
        $this->Transform = $transform;
        return $this;
    }
    /**
     * Add item to Transform value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\TransformType $item
     * @return \Sabre\AirTicket\Structs\TransformsType
     */
    public function addToTransform(\Sabre\AirTicket\Structs\TransformType $item)
    {
        $this->Transform[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\TransformsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
