<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketInfo Structs
 * @subpackage Structs
 */
class TicketInfo extends AbstractStructBase
{
    /**
     * The PNR
     * Meta informations extracted from the WSDL
     * - documentation: "PNR" is used to indicate whether the document number is on the face of PNR or only in the ticketing database.
     * - use: optional
     * @var bool
     */
    public $PNR;
    /**
     * The eTicketNumber
     * Meta informations extracted from the WSDL
     * - documentation: "eTicketNumber" is used to return ticket-related information.
     * - use: optional
     * @var string
     */
    public $eTicketNumber;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "RPH" is used as a reference place holder.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for TicketInfo
     * @uses TicketInfo::setPNR()
     * @uses TicketInfo::setETicketNumber()
     * @uses TicketInfo::setRPH()
     * @param bool $pNR
     * @param string $eTicketNumber
     * @param string $rPH
     */
    public function __construct($pNR = null, $eTicketNumber = null, $rPH = null)
    {
        $this
            ->setPNR($pNR)
            ->setETicketNumber($eTicketNumber)
            ->setRPH($rPH);
    }
    /**
     * Get PNR value
     * @return bool|null
     */
    public function getPNR()
    {
        return $this->PNR;
    }
    /**
     * Set PNR value
     * @param bool $pNR
     * @return \Sabre\AirTicket\Structs\TicketInfo
     */
    public function setPNR($pNR = null)
    {
        $this->PNR = $pNR;
        return $this;
    }
    /**
     * Get eTicketNumber value
     * @return string|null
     */
    public function getETicketNumber()
    {
        return $this->eTicketNumber;
    }
    /**
     * Set eTicketNumber value
     * @param string $eTicketNumber
     * @return \Sabre\AirTicket\Structs\TicketInfo
     */
    public function setETicketNumber($eTicketNumber = null)
    {
        $this->eTicketNumber = $eTicketNumber;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\AirTicket\Structs\TicketInfo
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\TicketInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
