<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticket Structs
 * @subpackage Structs
 */
class Ticket extends AbstractStructBase
{
    /**
     * The MiniItinerary
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\MiniItinerary
     */
    public $MiniItinerary;
    /**
     * The Remote
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\Remote
     */
    public $Remote;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CountryCode;
    /**
     * The LNIATA
     * Meta informations extracted from the WSDL
     * - documentation: "LNIATA" is used to specify a bag tag printer address.
     * - use: optional
     * @var string
     */
    public $LNIATA;
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - documentation: "Action" is used to specify an action code. Please note that this qualifier is only applicable to Sabre Sonic-hosted carriers.
     * - use: optional
     * @var string
     */
    public $Action;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: "Type" is used to specify the type of ticket to issue. Acceptable values for Type: ETR = electronic ticket (default), EMD= Electronic Miscellaneous Document, XETR = paper ticket, VCR = paper ticket (for airline use only).
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * Constructor method for Ticket
     * @uses Ticket::setMiniItinerary()
     * @uses Ticket::setRemote()
     * @uses Ticket::setCountryCode()
     * @uses Ticket::setLNIATA()
     * @uses Ticket::setAction()
     * @uses Ticket::setType()
     * @param \Sabre\AirTicket\Structs\MiniItinerary $miniItinerary
     * @param \Sabre\AirTicket\Structs\Remote $remote
     * @param string $countryCode
     * @param string $lNIATA
     * @param string $action
     * @param string $type
     */
    public function __construct(\Sabre\AirTicket\Structs\MiniItinerary $miniItinerary = null, \Sabre\AirTicket\Structs\Remote $remote = null, $countryCode = null, $lNIATA = null, $action = null, $type = null)
    {
        $this
            ->setMiniItinerary($miniItinerary)
            ->setRemote($remote)
            ->setCountryCode($countryCode)
            ->setLNIATA($lNIATA)
            ->setAction($action)
            ->setType($type);
    }
    /**
     * Get MiniItinerary value
     * @return \Sabre\AirTicket\Structs\MiniItinerary|null
     */
    public function getMiniItinerary()
    {
        return $this->MiniItinerary;
    }
    /**
     * Set MiniItinerary value
     * @param \Sabre\AirTicket\Structs\MiniItinerary $miniItinerary
     * @return \Sabre\AirTicket\Structs\Ticket
     */
    public function setMiniItinerary(\Sabre\AirTicket\Structs\MiniItinerary $miniItinerary = null)
    {
        $this->MiniItinerary = $miniItinerary;
        return $this;
    }
    /**
     * Get Remote value
     * @return \Sabre\AirTicket\Structs\Remote|null
     */
    public function getRemote()
    {
        return $this->Remote;
    }
    /**
     * Set Remote value
     * @param \Sabre\AirTicket\Structs\Remote $remote
     * @return \Sabre\AirTicket\Structs\Ticket
     */
    public function setRemote(\Sabre\AirTicket\Structs\Remote $remote = null)
    {
        $this->Remote = $remote;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \Sabre\AirTicket\Structs\Ticket
     */
    public function setCountryCode($countryCode = null)
    {
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get LNIATA value
     * @return string|null
     */
    public function getLNIATA()
    {
        return $this->LNIATA;
    }
    /**
     * Set LNIATA value
     * @param string $lNIATA
     * @return \Sabre\AirTicket\Structs\Ticket
     */
    public function setLNIATA($lNIATA = null)
    {
        $this->LNIATA = $lNIATA;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @param string $action
     * @return \Sabre\AirTicket\Structs\Ticket
     */
    public function setAction($action = null)
    {
        $this->Action = $action;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\AirTicket\Structs\Ticket
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\Ticket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
