<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SabreSonicTicketing Structs
 * Meta informations extracted from the WSDL
 * - documentation: "SabreSonicTicketing" is only valid for SabreSonic-based airlines, cannot combine with .../BSP_Ticketing, or .../Multiple CC_FOP.
 * @subpackage Structs
 */
class SabreSonicTicketing extends AbstractStructBase
{
    /**
     * The BasicFOP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\BasicFOP
     */
    public $BasicFOP;
    /**
     * The EnhancedMultipleFOP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\EnhancedMultipleFOP
     */
    public $EnhancedMultipleFOP;
    /**
     * The MultipleFOP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\MultipleFOP
     */
    public $MultipleFOP;
    /**
     * Constructor method for SabreSonicTicketing
     * @uses SabreSonicTicketing::setBasicFOP()
     * @uses SabreSonicTicketing::setEnhancedMultipleFOP()
     * @uses SabreSonicTicketing::setMultipleFOP()
     * @param \Sabre\AirTicket\Structs\BasicFOP $basicFOP
     * @param \Sabre\AirTicket\Structs\EnhancedMultipleFOP $enhancedMultipleFOP
     * @param \Sabre\AirTicket\Structs\MultipleFOP $multipleFOP
     */
    public function __construct(\Sabre\AirTicket\Structs\BasicFOP $basicFOP = null, \Sabre\AirTicket\Structs\EnhancedMultipleFOP $enhancedMultipleFOP = null, \Sabre\AirTicket\Structs\MultipleFOP $multipleFOP = null)
    {
        $this
            ->setBasicFOP($basicFOP)
            ->setEnhancedMultipleFOP($enhancedMultipleFOP)
            ->setMultipleFOP($multipleFOP);
    }
    /**
     * Get BasicFOP value
     * @return \Sabre\AirTicket\Structs\BasicFOP|null
     */
    public function getBasicFOP()
    {
        return $this->BasicFOP;
    }
    /**
     * Set BasicFOP value
     * @param \Sabre\AirTicket\Structs\BasicFOP $basicFOP
     * @return \Sabre\AirTicket\Structs\SabreSonicTicketing
     */
    public function setBasicFOP(\Sabre\AirTicket\Structs\BasicFOP $basicFOP = null)
    {
        $this->BasicFOP = $basicFOP;
        return $this;
    }
    /**
     * Get EnhancedMultipleFOP value
     * @return \Sabre\AirTicket\Structs\EnhancedMultipleFOP|null
     */
    public function getEnhancedMultipleFOP()
    {
        return $this->EnhancedMultipleFOP;
    }
    /**
     * Set EnhancedMultipleFOP value
     * @param \Sabre\AirTicket\Structs\EnhancedMultipleFOP $enhancedMultipleFOP
     * @return \Sabre\AirTicket\Structs\SabreSonicTicketing
     */
    public function setEnhancedMultipleFOP(\Sabre\AirTicket\Structs\EnhancedMultipleFOP $enhancedMultipleFOP = null)
    {
        $this->EnhancedMultipleFOP = $enhancedMultipleFOP;
        return $this;
    }
    /**
     * Get MultipleFOP value
     * @return \Sabre\AirTicket\Structs\MultipleFOP|null
     */
    public function getMultipleFOP()
    {
        return $this->MultipleFOP;
    }
    /**
     * Set MultipleFOP value
     * @param \Sabre\AirTicket\Structs\MultipleFOP $multipleFOP
     * @return \Sabre\AirTicket\Structs\SabreSonicTicketing
     */
    public function setMultipleFOP(\Sabre\AirTicket\Structs\MultipleFOP $multipleFOP = null)
    {
        $this->MultipleFOP = $multipleFOP;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\SabreSonicTicketing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
