<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Record Structs
 * Meta informations extracted from the WSDL
 * - documentation: In order to specify multiple PQR records to be issued please specify a range or specific record numbers by means of the element repetition. .../Ticketing/PricingQualifiers/PriceQuote/Record/@Reissue cannot be combined with
 * .../Ticketing/MiscQualifiers/Ticket
 * @subpackage Structs
 */
class Record extends AbstractStructBase
{
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - documentation: "Number" is used to specify a PQ number.
     * - use: required
     * @var int
     */
    public $Number;
    /**
     * The EndNumber
     * Meta informations extracted from the WSDL
     * - documentation: "EndNumber" is used to specify the ending PQ number in a range.
     * - use: optional
     * @var int
     */
    public $EndNumber;
    /**
     * The Reissue
     * Meta informations extracted from the WSDL
     * - documentation: "Reissue" is used to indicate that the particular PQ record is a PQ Reissue record.
     * - use: optional
     * @var bool
     */
    public $Reissue;
    /**
     * Constructor method for Record
     * @uses Record::setNumber()
     * @uses Record::setEndNumber()
     * @uses Record::setReissue()
     * @param int $number
     * @param int $endNumber
     * @param bool $reissue
     */
    public function __construct($number = null, $endNumber = null, $reissue = null)
    {
        $this
            ->setNumber($number)
            ->setEndNumber($endNumber)
            ->setReissue($reissue);
    }
    /**
     * Get Number value
     * @return int
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \Sabre\AirTicket\Structs\Record
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get EndNumber value
     * @return int|null
     */
    public function getEndNumber()
    {
        return $this->EndNumber;
    }
    /**
     * Set EndNumber value
     * @param int $endNumber
     * @return \Sabre\AirTicket\Structs\Record
     */
    public function setEndNumber($endNumber = null)
    {
        $this->EndNumber = $endNumber;
        return $this;
    }
    /**
     * Get Reissue value
     * @return bool|null
     */
    public function getReissue()
    {
        return $this->Reissue;
    }
    /**
     * Set Reissue value
     * @param bool $reissue
     * @return \Sabre\AirTicket\Structs\Record
     */
    public function setReissue($reissue = null)
    {
        $this->Reissue = $reissue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\Record
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
