<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostProcessing Structs
 * @subpackage Structs
 */
class PostProcessing extends AbstractStructBase
{
    /**
     * The EndTransaction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\EndTransaction
     */
    public $EndTransaction;
    /**
     * The acceptNegotiatedFare
     * Meta informations extracted from the WSDL
     * - documentation: "acceptNegotiatedFare" is used to accept a negotiated fare when it is not possible to ticket the stored fare.
     * - use: optional
     * @var bool
     */
    public $acceptNegotiatedFare;
    /**
     * The acceptPriceChanges
     * Meta informations extracted from the WSDL
     * - documentation: "acceptPriceChanges" is used to specify that system should issue a ticket even if price increases while processing.
     * - use: optional
     * @var bool
     */
    public $acceptPriceChanges;
    /**
     * The actionOnPQExpired
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $actionOnPQExpired;
    /**
     * Constructor method for PostProcessing
     * @uses PostProcessing::setEndTransaction()
     * @uses PostProcessing::setAcceptNegotiatedFare()
     * @uses PostProcessing::setAcceptPriceChanges()
     * @uses PostProcessing::setActionOnPQExpired()
     * @param \Sabre\AirTicket\Structs\EndTransaction $endTransaction
     * @param bool $acceptNegotiatedFare
     * @param bool $acceptPriceChanges
     * @param string $actionOnPQExpired
     */
    public function __construct(\Sabre\AirTicket\Structs\EndTransaction $endTransaction = null, $acceptNegotiatedFare = null, $acceptPriceChanges = null, $actionOnPQExpired = null)
    {
        $this
            ->setEndTransaction($endTransaction)
            ->setAcceptNegotiatedFare($acceptNegotiatedFare)
            ->setAcceptPriceChanges($acceptPriceChanges)
            ->setActionOnPQExpired($actionOnPQExpired);
    }
    /**
     * Get EndTransaction value
     * @return \Sabre\AirTicket\Structs\EndTransaction|null
     */
    public function getEndTransaction()
    {
        return $this->EndTransaction;
    }
    /**
     * Set EndTransaction value
     * @param \Sabre\AirTicket\Structs\EndTransaction $endTransaction
     * @return \Sabre\AirTicket\Structs\PostProcessing
     */
    public function setEndTransaction(\Sabre\AirTicket\Structs\EndTransaction $endTransaction = null)
    {
        $this->EndTransaction = $endTransaction;
        return $this;
    }
    /**
     * Get acceptNegotiatedFare value
     * @return bool|null
     */
    public function getAcceptNegotiatedFare()
    {
        return $this->acceptNegotiatedFare;
    }
    /**
     * Set acceptNegotiatedFare value
     * @param bool $acceptNegotiatedFare
     * @return \Sabre\AirTicket\Structs\PostProcessing
     */
    public function setAcceptNegotiatedFare($acceptNegotiatedFare = null)
    {
        $this->acceptNegotiatedFare = $acceptNegotiatedFare;
        return $this;
    }
    /**
     * Get acceptPriceChanges value
     * @return bool|null
     */
    public function getAcceptPriceChanges()
    {
        return $this->acceptPriceChanges;
    }
    /**
     * Set acceptPriceChanges value
     * @param bool $acceptPriceChanges
     * @return \Sabre\AirTicket\Structs\PostProcessing
     */
    public function setAcceptPriceChanges($acceptPriceChanges = null)
    {
        $this->acceptPriceChanges = $acceptPriceChanges;
        return $this;
    }
    /**
     * Get actionOnPQExpired value
     * @return string|null
     */
    public function getActionOnPQExpired()
    {
        return $this->actionOnPQExpired;
    }
    /**
     * Set actionOnPQExpired value
     * @param string $actionOnPQExpired
     * @return \Sabre\AirTicket\Structs\PostProcessing
     */
    public function setActionOnPQExpired($actionOnPQExpired = null)
    {
        $this->actionOnPQExpired = $actionOnPQExpired;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\PostProcessing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
