<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonName Structs
 * @subpackage Structs
 */
class PersonName extends AbstractStructBase
{
    /**
     * The NameNumber
     * Meta informations extracted from the WSDL
     * - documentation: "NameNumber" is used to specify a particular passenger name number to send the email notification to. Please note that the email address in the PNR's email field must be name associated to the specified name number.
     * - use: required
     * @var string
     */
    public $NameNumber;
    /**
     * Constructor method for PersonName
     * @uses PersonName::setNameNumber()
     * @param string $nameNumber
     */
    public function __construct($nameNumber = null)
    {
        $this
            ->setNameNumber($nameNumber);
    }
    /**
     * Get NameNumber value
     * @return string
     */
    public function getNameNumber()
    {
        return $this->NameNumber;
    }
    /**
     * Set NameNumber value
     * @param string $nameNumber
     * @return \Sabre\AirTicket\Structs\PersonName
     */
    public function setNameNumber($nameNumber = null)
    {
        $this->NameNumber = $nameNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\PersonName
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
