<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Endorsement Structs
 * @subpackage Structs
 */
class Endorsement extends AbstractStructBase
{
    /**
     * The Text
     * @var string
     */
    public $Text;
    /**
     * The Override
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Override;
    /**
     * Constructor method for Endorsement
     * @uses Endorsement::setText()
     * @uses Endorsement::setOverride()
     * @param string $text
     * @param bool $override
     */
    public function __construct($text = null, $override = null)
    {
        $this
            ->setText($text)
            ->setOverride($override);
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\AirTicket\Structs\Endorsement
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Override value
     * @return bool|null
     */
    public function getOverride()
    {
        return $this->Override;
    }
    /**
     * Set Override value
     * @param bool $override
     * @return \Sabre\AirTicket\Structs\Endorsement
     */
    public function setOverride($override = null)
    {
        $this->Override = $override;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\Endorsement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
