<?php

namespace Sabre\AirTicket\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTicketRQ Structs
 * @subpackage Structs
 */
class AirTicketRQ extends STL_Request_Payload
{
    /**
     * The Itinerary
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var \Sabre\AirTicket\Structs\Itinerary
     */
    public $Itinerary;
    /**
     * The Ticketing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 1
     * @var \Sabre\AirTicket\Structs\Ticketing[]
     */
    public $Ticketing;
    /**
     * The DesignatePrinter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\DesignatePrinter
     */
    public $DesignatePrinter;
    /**
     * The AccountingLines
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\AccountingLines
     */
    public $AccountingLines;
    /**
     * The PostProcessing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\AirTicket\Structs\PostProcessing
     */
    public $PostProcessing;
    /**
     * The targetCity
     * Meta informations extracted from the WSDL
     * - documentation: "TargetCity" is used to specify to which city service should change context using ContextChange (AAA) and the rest of the service uses new security. If empty or equals current city the context doesn't change.
     * - use: optional
     * @var string
     */
    public $targetCity;
    /**
     * Constructor method for AirTicketRQ
     * @uses AirTicketRQ::setItinerary()
     * @uses AirTicketRQ::setTicketing()
     * @uses AirTicketRQ::setDesignatePrinter()
     * @uses AirTicketRQ::setAccountingLines()
     * @uses AirTicketRQ::setPostProcessing()
     * @uses AirTicketRQ::setTargetCity()
     * @param \Sabre\AirTicket\Structs\Itinerary $itinerary
     * @param \Sabre\AirTicket\Structs\Ticketing[] $ticketing
     * @param \Sabre\AirTicket\Structs\DesignatePrinter $designatePrinter
     * @param \Sabre\AirTicket\Structs\AccountingLines $accountingLines
     * @param \Sabre\AirTicket\Structs\PostProcessing $postProcessing
     * @param string $targetCity
     */
    public function __construct(\Sabre\AirTicket\Structs\Itinerary $itinerary = null, array $ticketing = array(), \Sabre\AirTicket\Structs\DesignatePrinter $designatePrinter = null, \Sabre\AirTicket\Structs\AccountingLines $accountingLines = null, \Sabre\AirTicket\Structs\PostProcessing $postProcessing = null, $targetCity = null)
    {
        $this
            ->setItinerary($itinerary)
            ->setTicketing($ticketing)
            ->setDesignatePrinter($designatePrinter)
            ->setAccountingLines($accountingLines)
            ->setPostProcessing($postProcessing)
            ->setTargetCity($targetCity);
    }
    /**
     * Get Itinerary value
     * @return \Sabre\AirTicket\Structs\Itinerary
     */
    public function getItinerary()
    {
        return $this->Itinerary;
    }
    /**
     * Set Itinerary value
     * @param \Sabre\AirTicket\Structs\Itinerary $itinerary
     * @return \Sabre\AirTicket\Structs\AirTicketRQ
     */
    public function setItinerary(\Sabre\AirTicket\Structs\Itinerary $itinerary = null)
    {
        $this->Itinerary = $itinerary;
        return $this;
    }
    /**
     * Get Ticketing value
     * @return \Sabre\AirTicket\Structs\Ticketing[]
     */
    public function getTicketing()
    {
        return $this->Ticketing;
    }
    /**
     * Set Ticketing value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\Ticketing[] $ticketing
     * @return \Sabre\AirTicket\Structs\AirTicketRQ
     */
    public function setTicketing(array $ticketing = array())
    {
        $this->Ticketing = $ticketing;
        return $this;
    }
    /**
     * Add item to Ticketing value
     * @throws \InvalidArgumentException
     * @param \Sabre\AirTicket\Structs\Ticketing $item
     * @return \Sabre\AirTicket\Structs\AirTicketRQ
     */
    public function addToTicketing(\Sabre\AirTicket\Structs\Ticketing $item)
    {
        $this->Ticketing[] = $item;
        return $this;
    }
    /**
     * Get DesignatePrinter value
     * @return \Sabre\AirTicket\Structs\DesignatePrinter|null
     */
    public function getDesignatePrinter()
    {
        return $this->DesignatePrinter;
    }
    /**
     * Set DesignatePrinter value
     * @param \Sabre\AirTicket\Structs\DesignatePrinter $designatePrinter
     * @return \Sabre\AirTicket\Structs\AirTicketRQ
     */
    public function setDesignatePrinter(\Sabre\AirTicket\Structs\DesignatePrinter $designatePrinter = null)
    {
        $this->DesignatePrinter = $designatePrinter;
        return $this;
    }
    /**
     * Get AccountingLines value
     * @return \Sabre\AirTicket\Structs\AccountingLines|null
     */
    public function getAccountingLines()
    {
        return $this->AccountingLines;
    }
    /**
     * Set AccountingLines value
     * @param \Sabre\AirTicket\Structs\AccountingLines $accountingLines
     * @return \Sabre\AirTicket\Structs\AirTicketRQ
     */
    public function setAccountingLines(\Sabre\AirTicket\Structs\AccountingLines $accountingLines = null)
    {
        $this->AccountingLines = $accountingLines;
        return $this;
    }
    /**
     * Get PostProcessing value
     * @return \Sabre\AirTicket\Structs\PostProcessing|null
     */
    public function getPostProcessing()
    {
        return $this->PostProcessing;
    }
    /**
     * Set PostProcessing value
     * @param \Sabre\AirTicket\Structs\PostProcessing $postProcessing
     * @return \Sabre\AirTicket\Structs\AirTicketRQ
     */
    public function setPostProcessing(\Sabre\AirTicket\Structs\PostProcessing $postProcessing = null)
    {
        $this->PostProcessing = $postProcessing;
        return $this;
    }
    /**
     * Get targetCity value
     * @return string|null
     */
    public function getTargetCity()
    {
        return $this->targetCity;
    }
    /**
     * Set targetCity value
     * @param string $targetCity
     * @return \Sabre\AirTicket\Structs\AirTicketRQ
     */
    public function setTargetCity($targetCity = null)
    {
        $this->targetCity = $targetCity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\AirTicket\Structs\AirTicketRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
