<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VCCInformationType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Validating Carrier Commission Information
 * @subpackage Structs
 */
class VCCInformationType extends AbstractStructBase
{
    /**
     * The CommissionAmount
     * Meta informations extracted from the WSDL
     * - documentation: Commission Amount (in equivalent amount currency) | Used for amounts, max 3 decimals
     * - use: required
     * - fractionDigits: 3
     * @var float
     */
    public $CommissionAmount;
    /**
     * The FareComponentBreakdown
     * Meta informations extracted from the WSDL
     * - maxOccurs: 24
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\FareComponentBreakdownType[]
     */
    public $FareComponentBreakdown;
    /**
     * The ValidatingCarrier
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: [0-9A-Z]{2,3}
     * @var string
     */
    public $ValidatingCarrier;
    /**
     * The EarnedCommissionAmount
     * Meta informations extracted from the WSDL
     * - documentation: Earned Commission Amount | Used for amounts, max 3 decimals
     * - use: optional
     * - fractionDigits: 3
     * @var float
     */
    public $EarnedCommissionAmount;
    /**
     * The TotalAmountIncludingMarkUp
     * Meta informations extracted from the WSDL
     * - documentation: Total Commision amount including Mark-Up | Used for amounts, max 3 decimals
     * - use: optional
     * - fractionDigits: 3
     * @var float
     */
    public $TotalAmountIncludingMarkUp;
    /**
     * The CommissionPercent
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: Used for amounts, max 3 decimals
     * - fractionDigits: 3
     * @var float
     */
    public $CommissionPercent;
    /**
     * The CommissionContractQualifier
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: Commission Contract Qualifier
     * - maxLength: 20
     * - minLength: 2
     * @var string
     */
    public $CommissionContractQualifier;
    /**
     * Constructor method for VCCInformationType
     * @uses VCCInformationType::setCommissionAmount()
     * @uses VCCInformationType::setFareComponentBreakdown()
     * @uses VCCInformationType::setValidatingCarrier()
     * @uses VCCInformationType::setEarnedCommissionAmount()
     * @uses VCCInformationType::setTotalAmountIncludingMarkUp()
     * @uses VCCInformationType::setCommissionPercent()
     * @uses VCCInformationType::setCommissionContractQualifier()
     * @param float $commissionAmount
     * @param \Sabre\BargainFinderMax\Structs\FareComponentBreakdownType[] $fareComponentBreakdown
     * @param string $validatingCarrier
     * @param float $earnedCommissionAmount
     * @param float $totalAmountIncludingMarkUp
     * @param float $commissionPercent
     * @param string $commissionContractQualifier
     */
    public function __construct($commissionAmount = null, array $fareComponentBreakdown = array(), $validatingCarrier = null, $earnedCommissionAmount = null, $totalAmountIncludingMarkUp = null, $commissionPercent = null, $commissionContractQualifier = null)
    {
        $this
            ->setCommissionAmount($commissionAmount)
            ->setFareComponentBreakdown($fareComponentBreakdown)
            ->setValidatingCarrier($validatingCarrier)
            ->setEarnedCommissionAmount($earnedCommissionAmount)
            ->setTotalAmountIncludingMarkUp($totalAmountIncludingMarkUp)
            ->setCommissionPercent($commissionPercent)
            ->setCommissionContractQualifier($commissionContractQualifier);
    }
    /**
     * Get CommissionAmount value
     * @return float
     */
    public function getCommissionAmount()
    {
        return $this->CommissionAmount;
    }
    /**
     * Set CommissionAmount value
     * @param float $commissionAmount
     * @return \Sabre\BargainFinderMax\Structs\VCCInformationType
     */
    public function setCommissionAmount($commissionAmount = null)
    {
        $this->CommissionAmount = $commissionAmount;
        return $this;
    }
    /**
     * Get FareComponentBreakdown value
     * @return \Sabre\BargainFinderMax\Structs\FareComponentBreakdownType[]|null
     */
    public function getFareComponentBreakdown()
    {
        return $this->FareComponentBreakdown;
    }
    /**
     * Set FareComponentBreakdown value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FareComponentBreakdownType[] $fareComponentBreakdown
     * @return \Sabre\BargainFinderMax\Structs\VCCInformationType
     */
    public function setFareComponentBreakdown(array $fareComponentBreakdown = array())
    {
        $this->FareComponentBreakdown = $fareComponentBreakdown;
        return $this;
    }
    /**
     * Add item to FareComponentBreakdown value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FareComponentBreakdownType $item
     * @return \Sabre\BargainFinderMax\Structs\VCCInformationType
     */
    public function addToFareComponentBreakdown(\Sabre\BargainFinderMax\Structs\FareComponentBreakdownType $item)
    {
        $this->FareComponentBreakdown[] = $item;
        return $this;
    }
    /**
     * Get ValidatingCarrier value
     * @return string|null
     */
    public function getValidatingCarrier()
    {
        return $this->ValidatingCarrier;
    }
    /**
     * Set ValidatingCarrier value
     * @param string $validatingCarrier
     * @return \Sabre\BargainFinderMax\Structs\VCCInformationType
     */
    public function setValidatingCarrier($validatingCarrier = null)
    {
        $this->ValidatingCarrier = $validatingCarrier;
        return $this;
    }
    /**
     * Get EarnedCommissionAmount value
     * @return float|null
     */
    public function getEarnedCommissionAmount()
    {
        return $this->EarnedCommissionAmount;
    }
    /**
     * Set EarnedCommissionAmount value
     * @param float $earnedCommissionAmount
     * @return \Sabre\BargainFinderMax\Structs\VCCInformationType
     */
    public function setEarnedCommissionAmount($earnedCommissionAmount = null)
    {
        $this->EarnedCommissionAmount = $earnedCommissionAmount;
        return $this;
    }
    /**
     * Get TotalAmountIncludingMarkUp value
     * @return float|null
     */
    public function getTotalAmountIncludingMarkUp()
    {
        return $this->TotalAmountIncludingMarkUp;
    }
    /**
     * Set TotalAmountIncludingMarkUp value
     * @param float $totalAmountIncludingMarkUp
     * @return \Sabre\BargainFinderMax\Structs\VCCInformationType
     */
    public function setTotalAmountIncludingMarkUp($totalAmountIncludingMarkUp = null)
    {
        $this->TotalAmountIncludingMarkUp = $totalAmountIncludingMarkUp;
        return $this;
    }
    /**
     * Get CommissionPercent value
     * @return float|null
     */
    public function getCommissionPercent()
    {
        return $this->CommissionPercent;
    }
    /**
     * Set CommissionPercent value
     * @param float $commissionPercent
     * @return \Sabre\BargainFinderMax\Structs\VCCInformationType
     */
    public function setCommissionPercent($commissionPercent = null)
    {
        $this->CommissionPercent = $commissionPercent;
        return $this;
    }
    /**
     * Get CommissionContractQualifier value
     * @return string|null
     */
    public function getCommissionContractQualifier()
    {
        return $this->CommissionContractQualifier;
    }
    /**
     * Set CommissionContractQualifier value
     * @param string $commissionContractQualifier
     * @return \Sabre\BargainFinderMax\Structs\VCCInformationType
     */
    public function setCommissionContractQualifier($commissionContractQualifier = null)
    {
        $this->CommissionContractQualifier = $commissionContractQualifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\VCCInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
