<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelPreferences Structs
 * @subpackage Structs
 */
class TravelPreferences extends AbstractStructBase
{
    /**
     * The VendorPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\VendorPref[]
     */
    public $VendorPref;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * Constructor method for TravelPreferences
     * @uses TravelPreferences::setVendorPref()
     * @uses TravelPreferences::setTPA_Extensions()
     * @param \Sabre\BargainFinderMax\Structs\VendorPref[] $vendorPref
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     */
    public function __construct(array $vendorPref = array(), \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null)
    {
        $this
            ->setVendorPref($vendorPref)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get VendorPref value
     * @return \Sabre\BargainFinderMax\Structs\VendorPref[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\VendorPref[] $vendorPref
     * @return \Sabre\BargainFinderMax\Structs\TravelPreferences
     */
    public function setVendorPref(array $vendorPref = array())
    {
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\VendorPref $item
     * @return \Sabre\BargainFinderMax\Structs\TravelPreferences
     */
    public function addToVendorPref(\Sabre\BargainFinderMax\Structs\VendorPref $item)
    {
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \Sabre\BargainFinderMax\Structs\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\TravelPreferences
     */
    public function setTPA_Extensions(\Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\TravelPreferences
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
