<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionType Structs
 * Meta informations extracted from the WSDL
 * - documentation: IntelliSell Type | General or AdjustedSellingLevel
 * - pattern: [0-9A-Za-z]+
 * @subpackage Structs
 */
class TransactionType extends AbstractStructBase
{
    /**
     * The RequestType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RequestType;
    /**
     * The ServiceTag
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ServiceTag
     */
    public $ServiceTag;
    /**
     * The CustomerProfile
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CustomerProfile
     */
    public $CustomerProfile;
    /**
     * The PurchaseType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\PurchaseType
     */
    public $PurchaseType;
    /**
     * The SabreAth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\SabreAth
     */
    public $SabreAth;
    /**
     * The TranID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TranID
     */
    public $TranID;
    /**
     * The ClientSessionID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ClientSessionID
     */
    public $ClientSessionID;
    /**
     * The Branch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Branch
     */
    public $Branch;
    /**
     * The CompressResponse
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CompressResponse
     */
    public $CompressResponse;
    /**
     * The FareOverrides
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\FareOverrides
     */
    public $FareOverrides;
    /**
     * The Diagnostics
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Diagnostics
     */
    public $Diagnostics;
    /**
     * The SubagentData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\SubagentData
     */
    public $SubagentData;
    /**
     * The ResponseSorting
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ResponseSorting
     */
    public $ResponseSorting;
    /**
     * The SeatStatusSim
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\SeatStatusSimType
     */
    public $SeatStatusSim;
    /**
     * The AvailableLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AvailableLevel
     */
    public $AvailableLevel;
    /**
     * The ATSETest
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ATSETest
     */
    public $ATSETest;
    /**
     * The Debug
     * Meta informations extracted from the WSDL
     * - documentation: Turns on or off debug mode.
     * @var bool
     */
    public $Debug;
    /**
     * The DebugKey
     * Meta informations extracted from the WSDL
     * - documentation: Key unlocking disabled debug mode.
     * @var string
     */
    public $DebugKey;
    /**
     * The ConfigSet
     * Meta informations extracted from the WSDL
     * - documentation: Alternative configuration selector.
     * @var string
     */
    public $ConfigSet;
    /**
     * The DisableCache
     * Meta informations extracted from the WSDL
     * - documentation: Disables itinerary cache for this request (if it is enabled in this service).
     * @var bool
     */
    public $DisableCache;
    /**
     * The ChunkNumber
     * Meta informations extracted from the WSDL
     * - documentation: Helps Forwarder in keeping track of response parts generated as a result of request processing (AB only).
     * @var string
     */
    public $ChunkNumber;
    /**
     * The ShowItinSource
     * Meta informations extracted from the WSDL
     * - documentation: If enabled, Intellisell will return source for each itinerary.
     * @var bool
     */
    public $ShowItinSource;
    /**
     * Constructor method for TransactionType
     * @uses TransactionType::setRequestType()
     * @uses TransactionType::setServiceTag()
     * @uses TransactionType::setCustomerProfile()
     * @uses TransactionType::setPurchaseType()
     * @uses TransactionType::setSabreAth()
     * @uses TransactionType::setTranID()
     * @uses TransactionType::setClientSessionID()
     * @uses TransactionType::setBranch()
     * @uses TransactionType::setCompressResponse()
     * @uses TransactionType::setFareOverrides()
     * @uses TransactionType::setDiagnostics()
     * @uses TransactionType::setSubagentData()
     * @uses TransactionType::setResponseSorting()
     * @uses TransactionType::setSeatStatusSim()
     * @uses TransactionType::setAvailableLevel()
     * @uses TransactionType::setATSETest()
     * @uses TransactionType::setDebug()
     * @uses TransactionType::setDebugKey()
     * @uses TransactionType::setConfigSet()
     * @uses TransactionType::setDisableCache()
     * @uses TransactionType::setChunkNumber()
     * @uses TransactionType::setShowItinSource()
     * @param string $requestType
     * @param \Sabre\BargainFinderMax\Structs\ServiceTag $serviceTag
     * @param \Sabre\BargainFinderMax\Structs\CustomerProfile $customerProfile
     * @param \Sabre\BargainFinderMax\Structs\PurchaseType $purchaseType
     * @param \Sabre\BargainFinderMax\Structs\SabreAth $sabreAth
     * @param \Sabre\BargainFinderMax\Structs\TranID $tranID
     * @param \Sabre\BargainFinderMax\Structs\ClientSessionID $clientSessionID
     * @param \Sabre\BargainFinderMax\Structs\Branch $branch
     * @param \Sabre\BargainFinderMax\Structs\CompressResponse $compressResponse
     * @param \Sabre\BargainFinderMax\Structs\FareOverrides $fareOverrides
     * @param \Sabre\BargainFinderMax\Structs\Diagnostics $diagnostics
     * @param \Sabre\BargainFinderMax\Structs\SubagentData $subagentData
     * @param \Sabre\BargainFinderMax\Structs\ResponseSorting $responseSorting
     * @param \Sabre\BargainFinderMax\Structs\SeatStatusSimType $seatStatusSim
     * @param \Sabre\BargainFinderMax\Structs\AvailableLevel $availableLevel
     * @param \Sabre\BargainFinderMax\Structs\ATSETest $aTSETest
     * @param bool $debug
     * @param string $debugKey
     * @param string $configSet
     * @param bool $disableCache
     * @param string $chunkNumber
     * @param bool $showItinSource
     */
    public function __construct($requestType = null, \Sabre\BargainFinderMax\Structs\ServiceTag $serviceTag = null, \Sabre\BargainFinderMax\Structs\CustomerProfile $customerProfile = null, \Sabre\BargainFinderMax\Structs\PurchaseType $purchaseType = null, \Sabre\BargainFinderMax\Structs\SabreAth $sabreAth = null, \Sabre\BargainFinderMax\Structs\TranID $tranID = null, \Sabre\BargainFinderMax\Structs\ClientSessionID $clientSessionID = null, \Sabre\BargainFinderMax\Structs\Branch $branch = null, \Sabre\BargainFinderMax\Structs\CompressResponse $compressResponse = null, \Sabre\BargainFinderMax\Structs\FareOverrides $fareOverrides = null, \Sabre\BargainFinderMax\Structs\Diagnostics $diagnostics = null, \Sabre\BargainFinderMax\Structs\SubagentData $subagentData = null, \Sabre\BargainFinderMax\Structs\ResponseSorting $responseSorting = null, \Sabre\BargainFinderMax\Structs\SeatStatusSimType $seatStatusSim = null, \Sabre\BargainFinderMax\Structs\AvailableLevel $availableLevel = null, \Sabre\BargainFinderMax\Structs\ATSETest $aTSETest = null, $debug = null, $debugKey = null, $configSet = null, $disableCache = null, $chunkNumber = null, $showItinSource = null)
    {
        $this
            ->setRequestType($requestType)
            ->setServiceTag($serviceTag)
            ->setCustomerProfile($customerProfile)
            ->setPurchaseType($purchaseType)
            ->setSabreAth($sabreAth)
            ->setTranID($tranID)
            ->setClientSessionID($clientSessionID)
            ->setBranch($branch)
            ->setCompressResponse($compressResponse)
            ->setFareOverrides($fareOverrides)
            ->setDiagnostics($diagnostics)
            ->setSubagentData($subagentData)
            ->setResponseSorting($responseSorting)
            ->setSeatStatusSim($seatStatusSim)
            ->setAvailableLevel($availableLevel)
            ->setATSETest($aTSETest)
            ->setDebug($debug)
            ->setDebugKey($debugKey)
            ->setConfigSet($configSet)
            ->setDisableCache($disableCache)
            ->setChunkNumber($chunkNumber)
            ->setShowItinSource($showItinSource);
    }
    /**
     * Get RequestType value
     * @return string|null
     */
    public function getRequestType()
    {
        return $this->RequestType;
    }
    /**
     * Set RequestType value
     * @uses \Sabre\BargainFinderMax\Enums\RequestType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\RequestType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestType
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setRequestType($requestType = null)
    {
        $this->RequestType = $requestType;
        return $this;
    }
    /**
     * Get ServiceTag value
     * @return \Sabre\BargainFinderMax\Structs\ServiceTag|null
     */
    public function getServiceTag()
    {
        return $this->ServiceTag;
    }
    /**
     * Set ServiceTag value
     * @param \Sabre\BargainFinderMax\Structs\ServiceTag $serviceTag
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setServiceTag(\Sabre\BargainFinderMax\Structs\ServiceTag $serviceTag = null)
    {
        $this->ServiceTag = $serviceTag;
        return $this;
    }
    /**
     * Get CustomerProfile value
     * @return \Sabre\BargainFinderMax\Structs\CustomerProfile|null
     */
    public function getCustomerProfile()
    {
        return $this->CustomerProfile;
    }
    /**
     * Set CustomerProfile value
     * @param \Sabre\BargainFinderMax\Structs\CustomerProfile $customerProfile
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setCustomerProfile(\Sabre\BargainFinderMax\Structs\CustomerProfile $customerProfile = null)
    {
        $this->CustomerProfile = $customerProfile;
        return $this;
    }
    /**
     * Get PurchaseType value
     * @return \Sabre\BargainFinderMax\Structs\PurchaseType|null
     */
    public function getPurchaseType()
    {
        return $this->PurchaseType;
    }
    /**
     * Set PurchaseType value
     * @param \Sabre\BargainFinderMax\Structs\PurchaseType $purchaseType
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setPurchaseType(\Sabre\BargainFinderMax\Structs\PurchaseType $purchaseType = null)
    {
        $this->PurchaseType = $purchaseType;
        return $this;
    }
    /**
     * Get SabreAth value
     * @return \Sabre\BargainFinderMax\Structs\SabreAth|null
     */
    public function getSabreAth()
    {
        return $this->SabreAth;
    }
    /**
     * Set SabreAth value
     * @param \Sabre\BargainFinderMax\Structs\SabreAth $sabreAth
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setSabreAth(\Sabre\BargainFinderMax\Structs\SabreAth $sabreAth = null)
    {
        $this->SabreAth = $sabreAth;
        return $this;
    }
    /**
     * Get TranID value
     * @return \Sabre\BargainFinderMax\Structs\TranID|null
     */
    public function getTranID()
    {
        return $this->TranID;
    }
    /**
     * Set TranID value
     * @param \Sabre\BargainFinderMax\Structs\TranID $tranID
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setTranID(\Sabre\BargainFinderMax\Structs\TranID $tranID = null)
    {
        $this->TranID = $tranID;
        return $this;
    }
    /**
     * Get ClientSessionID value
     * @return \Sabre\BargainFinderMax\Structs\ClientSessionID|null
     */
    public function getClientSessionID()
    {
        return $this->ClientSessionID;
    }
    /**
     * Set ClientSessionID value
     * @param \Sabre\BargainFinderMax\Structs\ClientSessionID $clientSessionID
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setClientSessionID(\Sabre\BargainFinderMax\Structs\ClientSessionID $clientSessionID = null)
    {
        $this->ClientSessionID = $clientSessionID;
        return $this;
    }
    /**
     * Get Branch value
     * @return \Sabre\BargainFinderMax\Structs\Branch|null
     */
    public function getBranch()
    {
        return $this->Branch;
    }
    /**
     * Set Branch value
     * @param \Sabre\BargainFinderMax\Structs\Branch $branch
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setBranch(\Sabre\BargainFinderMax\Structs\Branch $branch = null)
    {
        $this->Branch = $branch;
        return $this;
    }
    /**
     * Get CompressResponse value
     * @return \Sabre\BargainFinderMax\Structs\CompressResponse|null
     */
    public function getCompressResponse()
    {
        return $this->CompressResponse;
    }
    /**
     * Set CompressResponse value
     * @param \Sabre\BargainFinderMax\Structs\CompressResponse $compressResponse
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setCompressResponse(\Sabre\BargainFinderMax\Structs\CompressResponse $compressResponse = null)
    {
        $this->CompressResponse = $compressResponse;
        return $this;
    }
    /**
     * Get FareOverrides value
     * @return \Sabre\BargainFinderMax\Structs\FareOverrides|null
     */
    public function getFareOverrides()
    {
        return $this->FareOverrides;
    }
    /**
     * Set FareOverrides value
     * @param \Sabre\BargainFinderMax\Structs\FareOverrides $fareOverrides
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setFareOverrides(\Sabre\BargainFinderMax\Structs\FareOverrides $fareOverrides = null)
    {
        $this->FareOverrides = $fareOverrides;
        return $this;
    }
    /**
     * Get Diagnostics value
     * @return \Sabre\BargainFinderMax\Structs\Diagnostics|null
     */
    public function getDiagnostics()
    {
        return $this->Diagnostics;
    }
    /**
     * Set Diagnostics value
     * @param \Sabre\BargainFinderMax\Structs\Diagnostics $diagnostics
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setDiagnostics(\Sabre\BargainFinderMax\Structs\Diagnostics $diagnostics = null)
    {
        $this->Diagnostics = $diagnostics;
        return $this;
    }
    /**
     * Get SubagentData value
     * @return \Sabre\BargainFinderMax\Structs\SubagentData|null
     */
    public function getSubagentData()
    {
        return $this->SubagentData;
    }
    /**
     * Set SubagentData value
     * @param \Sabre\BargainFinderMax\Structs\SubagentData $subagentData
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setSubagentData(\Sabre\BargainFinderMax\Structs\SubagentData $subagentData = null)
    {
        $this->SubagentData = $subagentData;
        return $this;
    }
    /**
     * Get ResponseSorting value
     * @return \Sabre\BargainFinderMax\Structs\ResponseSorting|null
     */
    public function getResponseSorting()
    {
        return $this->ResponseSorting;
    }
    /**
     * Set ResponseSorting value
     * @param \Sabre\BargainFinderMax\Structs\ResponseSorting $responseSorting
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setResponseSorting(\Sabre\BargainFinderMax\Structs\ResponseSorting $responseSorting = null)
    {
        $this->ResponseSorting = $responseSorting;
        return $this;
    }
    /**
     * Get SeatStatusSim value
     * @return \Sabre\BargainFinderMax\Structs\SeatStatusSimType|null
     */
    public function getSeatStatusSim()
    {
        return $this->SeatStatusSim;
    }
    /**
     * Set SeatStatusSim value
     * @param \Sabre\BargainFinderMax\Structs\SeatStatusSimType $seatStatusSim
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setSeatStatusSim(\Sabre\BargainFinderMax\Structs\SeatStatusSimType $seatStatusSim = null)
    {
        $this->SeatStatusSim = $seatStatusSim;
        return $this;
    }
    /**
     * Get AvailableLevel value
     * @return \Sabre\BargainFinderMax\Structs\AvailableLevel|null
     */
    public function getAvailableLevel()
    {
        return $this->AvailableLevel;
    }
    /**
     * Set AvailableLevel value
     * @param \Sabre\BargainFinderMax\Structs\AvailableLevel $availableLevel
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setAvailableLevel(\Sabre\BargainFinderMax\Structs\AvailableLevel $availableLevel = null)
    {
        $this->AvailableLevel = $availableLevel;
        return $this;
    }
    /**
     * Get ATSETest value
     * @return \Sabre\BargainFinderMax\Structs\ATSETest|null
     */
    public function getATSETest()
    {
        return $this->ATSETest;
    }
    /**
     * Set ATSETest value
     * @param \Sabre\BargainFinderMax\Structs\ATSETest $aTSETest
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setATSETest(\Sabre\BargainFinderMax\Structs\ATSETest $aTSETest = null)
    {
        $this->ATSETest = $aTSETest;
        return $this;
    }
    /**
     * Get Debug value
     * @return bool|null
     */
    public function getDebug()
    {
        return $this->Debug;
    }
    /**
     * Set Debug value
     * @param bool $debug
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setDebug($debug = null)
    {
        $this->Debug = $debug;
        return $this;
    }
    /**
     * Get DebugKey value
     * @return string|null
     */
    public function getDebugKey()
    {
        return $this->DebugKey;
    }
    /**
     * Set DebugKey value
     * @param string $debugKey
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setDebugKey($debugKey = null)
    {
        $this->DebugKey = $debugKey;
        return $this;
    }
    /**
     * Get ConfigSet value
     * @return string|null
     */
    public function getConfigSet()
    {
        return $this->ConfigSet;
    }
    /**
     * Set ConfigSet value
     * @param string $configSet
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setConfigSet($configSet = null)
    {
        $this->ConfigSet = $configSet;
        return $this;
    }
    /**
     * Get DisableCache value
     * @return bool|null
     */
    public function getDisableCache()
    {
        return $this->DisableCache;
    }
    /**
     * Set DisableCache value
     * @param bool $disableCache
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setDisableCache($disableCache = null)
    {
        $this->DisableCache = $disableCache;
        return $this;
    }
    /**
     * Get ChunkNumber value
     * @return string|null
     */
    public function getChunkNumber()
    {
        return $this->ChunkNumber;
    }
    /**
     * Set ChunkNumber value
     * @param string $chunkNumber
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setChunkNumber($chunkNumber = null)
    {
        $this->ChunkNumber = $chunkNumber;
        return $this;
    }
    /**
     * Get ShowItinSource value
     * @return bool|null
     */
    public function getShowItinSource()
    {
        return $this->ShowItinSource;
    }
    /**
     * Set ShowItinSource value
     * @param bool $showItinSource
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public function setShowItinSource($showItinSource = null)
    {
        $this->ShowItinSource = $showItinSource;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\TransactionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
