<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeOfDayRange Structs
 * @subpackage Structs
 */
class TimeOfDayRange extends AbstractStructBase
{
    /**
     * The Begin
     * Meta informations extracted from the WSDL
     * - documentation: Beginning of the TimeOfDayRange in HHMM format. | IntelliSell Time Window Boundary type in format HHMM.
     * - use: required
     * - pattern: ([0-1][0-9]|2[0-3])[0-5][0-9]
     * @var string
     */
    public $Begin;
    /**
     * The End
     * Meta informations extracted from the WSDL
     * - documentation: End of the TimeOfDayRange in HHMM format. | IntelliSell Time Window Boundary type in format HHMM.
     * - use: required
     * - pattern: ([0-1][0-9]|2[0-3])[0-5][0-9]
     * @var string
     */
    public $End;
    /**
     * The Percentage
     * Meta informations extracted from the WSDL
     * - documentation: Defines how many percent options should be in the TimeOfDayRange.
     * - use: required
     * - maxInclusive: 100
     * - minInclusive: 0
     * @var int
     */
    public $Percentage;
    /**
     * Constructor method for TimeOfDayRange
     * @uses TimeOfDayRange::setBegin()
     * @uses TimeOfDayRange::setEnd()
     * @uses TimeOfDayRange::setPercentage()
     * @param string $begin
     * @param string $end
     * @param int $percentage
     */
    public function __construct($begin = null, $end = null, $percentage = null)
    {
        $this
            ->setBegin($begin)
            ->setEnd($end)
            ->setPercentage($percentage);
    }
    /**
     * Get Begin value
     * @return string
     */
    public function getBegin()
    {
        return $this->Begin;
    }
    /**
     * Set Begin value
     * @param string $begin
     * @return \Sabre\BargainFinderMax\Structs\TimeOfDayRange
     */
    public function setBegin($begin = null)
    {
        $this->Begin = $begin;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \Sabre\BargainFinderMax\Structs\TimeOfDayRange
     */
    public function setEnd($end = null)
    {
        $this->End = $end;
        return $this;
    }
    /**
     * Get Percentage value
     * @return int
     */
    public function getPercentage()
    {
        return $this->Percentage;
    }
    /**
     * Set Percentage value
     * @param int $percentage
     * @return \Sabre\BargainFinderMax\Structs\TimeOfDayRange
     */
    public function setPercentage($percentage = null)
    {
        $this->Percentage = $percentage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\TimeOfDayRange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
