<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketDistribPrefType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Type of ticket distribution to be used with this collection of preferences. | Used for Character Strings, length 0 to 64
 * - maxLength: 64
 * - minLength: 0
 * @subpackage Structs
 */
class TicketDistribPrefType extends AbstractStructBase
{
    /**
     * The _
     * Meta informations extracted from the WSDL
     * - documentation: Used for Character Strings, length 0 to 64
     * - maxLength: 64
     * - minLength: 0
     * @var string
     */
    public $_;
    /**
     * The DistribType
     * Meta informations extracted from the WSDL
     * - documentation: Ticket distribution method; such as Fax, Email, Courier, Mail, Airport_Pickup, City_Office, Hotel_Desk, WillCall, etc. | Used for codes in the OTA code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * @var string
     */
    public $DistribType;
    /**
     * The TicketTime
     * Meta informations extracted from the WSDL
     * - documentation: Ticket turnaround time desired, amount of time requested to deliver tickets.
     * @var string
     */
    public $TicketTime;
    /**
     * The PreferLevel
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for TicketDistribPrefType
     * @uses TicketDistribPrefType::set_()
     * @uses TicketDistribPrefType::setDistribType()
     * @uses TicketDistribPrefType::setTicketTime()
     * @uses TicketDistribPrefType::setPreferLevel()
     * @param string $_
     * @param string $distribType
     * @param string $ticketTime
     * @param string $preferLevel
     */
    public function __construct($_ = null, $distribType = null, $ticketTime = null, $preferLevel = null)
    {
        $this
            ->set_($_)
            ->setDistribType($distribType)
            ->setTicketTime($ticketTime)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\BargainFinderMax\Structs\TicketDistribPrefType
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get DistribType value
     * @return string|null
     */
    public function getDistribType()
    {
        return $this->DistribType;
    }
    /**
     * Set DistribType value
     * @param string $distribType
     * @return \Sabre\BargainFinderMax\Structs\TicketDistribPrefType
     */
    public function setDistribType($distribType = null)
    {
        $this->DistribType = $distribType;
        return $this;
    }
    /**
     * Get TicketTime value
     * @return string|null
     */
    public function getTicketTime()
    {
        return $this->TicketTime;
    }
    /**
     * Set TicketTime value
     * @param string $ticketTime
     * @return \Sabre\BargainFinderMax\Structs\TicketDistribPrefType
     */
    public function setTicketTime($ticketTime = null)
    {
        $this->TicketTime = $ticketTime;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \Sabre\BargainFinderMax\Enums\PreferLevelType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \Sabre\BargainFinderMax\Structs\TicketDistribPrefType
     */
    public function setPreferLevel($preferLevel = null)
    {
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\TicketDistribPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
