<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatisticsType Structs
 * @subpackage Structs
 */
class StatisticsType extends AbstractStructBase
{
    /**
     * The Itineraries
     * Meta informations extracted from the WSDL
     * - documentation: Number of options returned
     * @var int
     */
    public $Itineraries;
    /**
     * The Branded
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Total number of Branded OneWay itineraries returned (Sum of itins in all legs combined)
     * - use: optional
     * @var int
     */
    public $Branded;
    /**
     * The OneWay
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Total number of Simple OneWay itineraries returned (Sum of itins in all legs combined)
     * - use: optional
     * @var int
     */
    public $OneWay;
    /**
     * The Departed
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Count for departed itineraries returned
     * - use: optional
     * @var int
     */
    public $Departed;
    /**
     * The SoldOut
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Count for sold out itineraries returned
     * - use: optional
     * @var int
     */
    public $SoldOut;
    /**
     * The LegMissed
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Count for itineraries with missing legs returned
     * - use: optional
     * @var int
     */
    public $LegMissed;
    /**
     * Constructor method for StatisticsType
     * @uses StatisticsType::setItineraries()
     * @uses StatisticsType::setBranded()
     * @uses StatisticsType::setOneWay()
     * @uses StatisticsType::setDeparted()
     * @uses StatisticsType::setSoldOut()
     * @uses StatisticsType::setLegMissed()
     * @param int $itineraries
     * @param int $branded
     * @param int $oneWay
     * @param int $departed
     * @param int $soldOut
     * @param int $legMissed
     */
    public function __construct($itineraries = null, $branded = '0', $oneWay = '0', $departed = '0', $soldOut = '0', $legMissed = '0')
    {
        $this
            ->setItineraries($itineraries)
            ->setBranded($branded)
            ->setOneWay($oneWay)
            ->setDeparted($departed)
            ->setSoldOut($soldOut)
            ->setLegMissed($legMissed);
    }
    /**
     * Get Itineraries value
     * @return int|null
     */
    public function getItineraries()
    {
        return $this->Itineraries;
    }
    /**
     * Set Itineraries value
     * @param int $itineraries
     * @return \Sabre\BargainFinderMax\Structs\StatisticsType
     */
    public function setItineraries($itineraries = null)
    {
        $this->Itineraries = $itineraries;
        return $this;
    }
    /**
     * Get Branded value
     * @return int|null
     */
    public function getBranded()
    {
        return $this->Branded;
    }
    /**
     * Set Branded value
     * @param int $branded
     * @return \Sabre\BargainFinderMax\Structs\StatisticsType
     */
    public function setBranded($branded = '0')
    {
        $this->Branded = $branded;
        return $this;
    }
    /**
     * Get OneWay value
     * @return int|null
     */
    public function getOneWay()
    {
        return $this->OneWay;
    }
    /**
     * Set OneWay value
     * @param int $oneWay
     * @return \Sabre\BargainFinderMax\Structs\StatisticsType
     */
    public function setOneWay($oneWay = '0')
    {
        $this->OneWay = $oneWay;
        return $this;
    }
    /**
     * Get Departed value
     * @return int|null
     */
    public function getDeparted()
    {
        return $this->Departed;
    }
    /**
     * Set Departed value
     * @param int $departed
     * @return \Sabre\BargainFinderMax\Structs\StatisticsType
     */
    public function setDeparted($departed = '0')
    {
        $this->Departed = $departed;
        return $this;
    }
    /**
     * Get SoldOut value
     * @return int|null
     */
    public function getSoldOut()
    {
        return $this->SoldOut;
    }
    /**
     * Set SoldOut value
     * @param int $soldOut
     * @return \Sabre\BargainFinderMax\Structs\StatisticsType
     */
    public function setSoldOut($soldOut = '0')
    {
        $this->SoldOut = $soldOut;
        return $this;
    }
    /**
     * Get LegMissed value
     * @return int|null
     */
    public function getLegMissed()
    {
        return $this->LegMissed;
    }
    /**
     * Set LegMissed value
     * @param int $legMissed
     * @return \Sabre\BargainFinderMax\Structs\StatisticsType
     */
    public function setLegMissed($legMissed = '0')
    {
        $this->LegMissed = $legMissed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\StatisticsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
