<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SourceBookingChannelType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Specifies the booking channel type and whether it is the primary means of connectivity of the source.
 * @subpackage Structs
 */
class SourceBookingChannelType extends BookingChannelType
{
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the company that is associated with the booking channel.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CompanyNameType
     */
    public $CompanyName;
    /**
     * Constructor method for SourceBookingChannelType
     * @uses SourceBookingChannelType::setCompanyName()
     * @param \Sabre\BargainFinderMax\Structs\CompanyNameType $companyName
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\CompanyNameType $companyName = null)
    {
        $this
            ->setCompanyName($companyName);
    }
    /**
     * Get CompanyName value
     * @return \Sabre\BargainFinderMax\Structs\CompanyNameType|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param \Sabre\BargainFinderMax\Structs\CompanyNameType $companyName
     * @return \Sabre\BargainFinderMax\Structs\SourceBookingChannelType
     */
    public function setCompanyName(\Sabre\BargainFinderMax\Structs\CompanyNameType $companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\SourceBookingChannelType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
