<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SoldOutLegType Structs
 * @subpackage Structs
 */
class SoldOutLegType extends AbstractStructBase
{
    /**
     * The Ref
     * Meta informations extracted from the WSDL
     * - documentation: Reference to LegDescription ID
     * - use: required
     * @var int
     */
    public $Ref;
    /**
     * The SoldOutSchedule
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\SoldOutSchedule[]
     */
    public $SoldOutSchedule;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The BrandCode
     * Meta informations extracted from the WSDL
     * - documentation: Brand Code(ID)
     * - use: optional
     * @var string
     */
    public $BrandCode;
    /**
     * The BrandDescription
     * Meta informations extracted from the WSDL
     * - documentation: Brand Description
     * - use: optional
     * @var string
     */
    public $BrandDescription;
    /**
     * The ProgramID
     * Meta informations extracted from the WSDL
     * - documentation: Program ID
     * - use: optional
     * @var string
     */
    public $ProgramID;
    /**
     * The ProgramCode
     * Meta informations extracted from the WSDL
     * - documentation: Program Code
     * - use: optional
     * @var string
     */
    public $ProgramCode;
    /**
     * The ProgramName
     * Meta informations extracted from the WSDL
     * - documentation: Program Name
     * - use: optional
     * @var string
     */
    public $ProgramName;
    /**
     * The ProgramSystemCode
     * Meta informations extracted from the WSDL
     * - documentation: Program System Code
     * - use: optional
     * @var string
     */
    public $ProgramSystemCode;
    /**
     * Constructor method for SoldOutLegType
     * @uses SoldOutLegType::setRef()
     * @uses SoldOutLegType::setSoldOutSchedule()
     * @uses SoldOutLegType::setStatus()
     * @uses SoldOutLegType::setBrandCode()
     * @uses SoldOutLegType::setBrandDescription()
     * @uses SoldOutLegType::setProgramID()
     * @uses SoldOutLegType::setProgramCode()
     * @uses SoldOutLegType::setProgramName()
     * @uses SoldOutLegType::setProgramSystemCode()
     * @param int $ref
     * @param \Sabre\BargainFinderMax\Structs\SoldOutSchedule[] $soldOutSchedule
     * @param string $status
     * @param string $brandCode
     * @param string $brandDescription
     * @param string $programID
     * @param string $programCode
     * @param string $programName
     * @param string $programSystemCode
     */
    public function __construct($ref = null, array $soldOutSchedule = array(), $status = null, $brandCode = null, $brandDescription = null, $programID = null, $programCode = null, $programName = null, $programSystemCode = null)
    {
        $this
            ->setRef($ref)
            ->setSoldOutSchedule($soldOutSchedule)
            ->setStatus($status)
            ->setBrandCode($brandCode)
            ->setBrandDescription($brandDescription)
            ->setProgramID($programID)
            ->setProgramCode($programCode)
            ->setProgramName($programName)
            ->setProgramSystemCode($programSystemCode);
    }
    /**
     * Get Ref value
     * @return int
     */
    public function getRef()
    {
        return $this->Ref;
    }
    /**
     * Set Ref value
     * @param int $ref
     * @return \Sabre\BargainFinderMax\Structs\SoldOutLegType
     */
    public function setRef($ref = null)
    {
        $this->Ref = $ref;
        return $this;
    }
    /**
     * Get SoldOutSchedule value
     * @return \Sabre\BargainFinderMax\Structs\SoldOutSchedule[]|null
     */
    public function getSoldOutSchedule()
    {
        return $this->SoldOutSchedule;
    }
    /**
     * Set SoldOutSchedule value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\SoldOutSchedule[] $soldOutSchedule
     * @return \Sabre\BargainFinderMax\Structs\SoldOutLegType
     */
    public function setSoldOutSchedule(array $soldOutSchedule = array())
    {
        $this->SoldOutSchedule = $soldOutSchedule;
        return $this;
    }
    /**
     * Add item to SoldOutSchedule value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\SoldOutSchedule $item
     * @return \Sabre\BargainFinderMax\Structs\SoldOutLegType
     */
    public function addToSoldOutSchedule(\Sabre\BargainFinderMax\Structs\SoldOutSchedule $item)
    {
        $this->SoldOutSchedule[] = $item;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\BargainFinderMax\Structs\SoldOutLegType
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get BrandCode value
     * @return string|null
     */
    public function getBrandCode()
    {
        return $this->BrandCode;
    }
    /**
     * Set BrandCode value
     * @param string $brandCode
     * @return \Sabre\BargainFinderMax\Structs\SoldOutLegType
     */
    public function setBrandCode($brandCode = null)
    {
        $this->BrandCode = $brandCode;
        return $this;
    }
    /**
     * Get BrandDescription value
     * @return string|null
     */
    public function getBrandDescription()
    {
        return $this->BrandDescription;
    }
    /**
     * Set BrandDescription value
     * @param string $brandDescription
     * @return \Sabre\BargainFinderMax\Structs\SoldOutLegType
     */
    public function setBrandDescription($brandDescription = null)
    {
        $this->BrandDescription = $brandDescription;
        return $this;
    }
    /**
     * Get ProgramID value
     * @return string|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \Sabre\BargainFinderMax\Structs\SoldOutLegType
     */
    public function setProgramID($programID = null)
    {
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get ProgramCode value
     * @return string|null
     */
    public function getProgramCode()
    {
        return $this->ProgramCode;
    }
    /**
     * Set ProgramCode value
     * @param string $programCode
     * @return \Sabre\BargainFinderMax\Structs\SoldOutLegType
     */
    public function setProgramCode($programCode = null)
    {
        $this->ProgramCode = $programCode;
        return $this;
    }
    /**
     * Get ProgramName value
     * @return string|null
     */
    public function getProgramName()
    {
        return $this->ProgramName;
    }
    /**
     * Set ProgramName value
     * @param string $programName
     * @return \Sabre\BargainFinderMax\Structs\SoldOutLegType
     */
    public function setProgramName($programName = null)
    {
        $this->ProgramName = $programName;
        return $this;
    }
    /**
     * Get ProgramSystemCode value
     * @return string|null
     */
    public function getProgramSystemCode()
    {
        return $this->ProgramSystemCode;
    }
    /**
     * Set ProgramSystemCode value
     * @param string $programSystemCode
     * @return \Sabre\BargainFinderMax\Structs\SoldOutLegType
     */
    public function setProgramSystemCode($programSystemCode = null)
    {
        $this->ProgramSystemCode = $programSystemCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\SoldOutLegType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
