<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SegmentType Structs
 * Meta informations extracted from the WSDL
 * - minOccurs: 0
 * @subpackage Structs
 */
class SegmentType extends AbstractStructBase
{
    /**
     * The BookingCode
     * Meta informations extracted from the WSDL
     * - documentation: Booking code | Booking code type | Booking code
     * - use: required
     * - length: 1
     * - pattern: [A-Z]
     * @var string
     */
    public $BookingCode;
    /**
     * The CabinCode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CabinCode;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The DualInventoryCode
     * Meta informations extracted from the WSDL
     * - documentation: Additional booking code required available | Booking code type | Booking code
     * - length: 1
     * - pattern: [A-Z]
     * @var string
     */
    public $DualInventoryCode;
    /**
     * The MealCode
     * @var string
     */
    public $MealCode;
    /**
     * The SeatsAvailable
     * Meta informations extracted from the WSDL
     * - documentation: Seats available
     * @var int
     */
    public $SeatsAvailable;
    /**
     * The AvailabilityBreak
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Availability break
     * @var bool
     */
    public $AvailabilityBreak;
    /**
     * Constructor method for SegmentType
     * @uses SegmentType::setBookingCode()
     * @uses SegmentType::setCabinCode()
     * @uses SegmentType::setCode()
     * @uses SegmentType::setDualInventoryCode()
     * @uses SegmentType::setMealCode()
     * @uses SegmentType::setSeatsAvailable()
     * @uses SegmentType::setAvailabilityBreak()
     * @param string $bookingCode
     * @param string $cabinCode
     * @param string $code
     * @param string $dualInventoryCode
     * @param string $mealCode
     * @param int $seatsAvailable
     * @param bool $availabilityBreak
     */
    public function __construct($bookingCode = null, $cabinCode = null, $code = null, $dualInventoryCode = null, $mealCode = null, $seatsAvailable = null, $availabilityBreak = false)
    {
        $this
            ->setBookingCode($bookingCode)
            ->setCabinCode($cabinCode)
            ->setCode($code)
            ->setDualInventoryCode($dualInventoryCode)
            ->setMealCode($mealCode)
            ->setSeatsAvailable($seatsAvailable)
            ->setAvailabilityBreak($availabilityBreak);
    }
    /**
     * Get BookingCode value
     * @return string
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param string $bookingCode
     * @return \Sabre\BargainFinderMax\Structs\SegmentType
     */
    public function setBookingCode($bookingCode = null)
    {
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get CabinCode value
     * @return string
     */
    public function getCabinCode()
    {
        return $this->CabinCode;
    }
    /**
     * Set CabinCode value
     * @param string $cabinCode
     * @return \Sabre\BargainFinderMax\Structs\SegmentType
     */
    public function setCabinCode($cabinCode = null)
    {
        $this->CabinCode = $cabinCode;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\BargainFinderMax\Structs\SegmentType
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get DualInventoryCode value
     * @return string|null
     */
    public function getDualInventoryCode()
    {
        return $this->DualInventoryCode;
    }
    /**
     * Set DualInventoryCode value
     * @param string $dualInventoryCode
     * @return \Sabre\BargainFinderMax\Structs\SegmentType
     */
    public function setDualInventoryCode($dualInventoryCode = null)
    {
        $this->DualInventoryCode = $dualInventoryCode;
        return $this;
    }
    /**
     * Get MealCode value
     * @return string|null
     */
    public function getMealCode()
    {
        return $this->MealCode;
    }
    /**
     * Set MealCode value
     * @param string $mealCode
     * @return \Sabre\BargainFinderMax\Structs\SegmentType
     */
    public function setMealCode($mealCode = null)
    {
        $this->MealCode = $mealCode;
        return $this;
    }
    /**
     * Get SeatsAvailable value
     * @return int|null
     */
    public function getSeatsAvailable()
    {
        return $this->SeatsAvailable;
    }
    /**
     * Set SeatsAvailable value
     * @param int $seatsAvailable
     * @return \Sabre\BargainFinderMax\Structs\SegmentType
     */
    public function setSeatsAvailable($seatsAvailable = null)
    {
        $this->SeatsAvailable = $seatsAvailable;
        return $this;
    }
    /**
     * Get AvailabilityBreak value
     * @return bool|null
     */
    public function getAvailabilityBreak()
    {
        return $this->AvailabilityBreak;
    }
    /**
     * Set AvailabilityBreak value
     * @param bool $availabilityBreak
     * @return \Sabre\BargainFinderMax\Structs\SegmentType
     */
    public function setAvailabilityBreak($availabilityBreak = false)
    {
        $this->AvailabilityBreak = $availabilityBreak;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\SegmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
