<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Segment Structs
 * Meta informations extracted from the WSDL
 * - documentation: Index of the segment covered by this baggage information relative to begining of itinerary starting with 0
 * @subpackage Structs
 */
class Segment extends AbstractStructBase
{
    /**
     * The LegIndex
     * Meta informations extracted from the WSDL
     * - documentation: Refers to OriginDestinationOption of current itinerary
     * - use: required
     * @var int
     */
    public $LegIndex;
    /**
     * The FlightIndex
     * Meta informations extracted from the WSDL
     * - documentation: Refers to FlightSegment within OriginDestinationOption of current itinerary
     * - use: required
     * @var int
     */
    public $FlightIndex;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Id of segment that current baggage information applies to.
     * - use: required
     * @var int
     */
    public $Id;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $ID;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - documentation: Reference to the flight segment
     * - use: optional
     * @var int
     */
    public $Number;
    /**
     * The ProgramID
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ProgramID;
    /**
     * The ProgramCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ProgramCode;
    /**
     * The ProgramDescription
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ProgramDescription;
    /**
     * The ProgramSystemCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ProgramSystemCode;
    /**
     * The BrandID
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BrandID;
    /**
     * The BrandName
     * Meta informations extracted from the WSDL
     * - documentation: Used to indicate brand name
     * - use: optional
     * @var string
     */
    public $BrandName;
    /**
     * The FareStatus
     * Meta informations extracted from the WSDL
     * - documentation: If possible detailed reason why fare could not be returned. "A" means "Class is not available", "O" - "Class is not offered", "F" - "No fare found or applicable", "N" - unknown status.
     * - use: optional
     * @var string
     */
    public $FareStatus;
    /**
     * Constructor method for Segment
     * @uses Segment::setLegIndex()
     * @uses Segment::setFlightIndex()
     * @uses Segment::setId()
     * @uses Segment::setID_1()
     * @uses Segment::setNumber()
     * @uses Segment::setProgramID()
     * @uses Segment::setProgramCode()
     * @uses Segment::setProgramDescription()
     * @uses Segment::setProgramSystemCode()
     * @uses Segment::setBrandID()
     * @uses Segment::setBrandName()
     * @uses Segment::setFareStatus()
     * @param int $legIndex
     * @param int $flightIndex
     * @param int $id
     * @param int $iD
     * @param int $number
     * @param string $programID
     * @param string $programCode
     * @param string $programDescription
     * @param string $programSystemCode
     * @param string $brandID
     * @param string $brandName
     * @param string $fareStatus
     */
    public function __construct($legIndex = null, $flightIndex = null, $id = null, $iD = null, $number = null, $programID = null, $programCode = null, $programDescription = null, $programSystemCode = null, $brandID = null, $brandName = null, $fareStatus = null)
    {
        $this
            ->setLegIndex($legIndex)
            ->setFlightIndex($flightIndex)
            ->setId($id)
            ->setID_1($iD)
            ->setNumber($number)
            ->setProgramID($programID)
            ->setProgramCode($programCode)
            ->setProgramDescription($programDescription)
            ->setProgramSystemCode($programSystemCode)
            ->setBrandID($brandID)
            ->setBrandName($brandName)
            ->setFareStatus($fareStatus);
    }
    /**
     * Get LegIndex value
     * @return int
     */
    public function getLegIndex()
    {
        return $this->LegIndex;
    }
    /**
     * Set LegIndex value
     * @param int $legIndex
     * @return \Sabre\BargainFinderMax\Structs\Segment
     */
    public function setLegIndex($legIndex = null)
    {
        $this->LegIndex = $legIndex;
        return $this;
    }
    /**
     * Get FlightIndex value
     * @return int
     */
    public function getFlightIndex()
    {
        return $this->FlightIndex;
    }
    /**
     * Set FlightIndex value
     * @param int $flightIndex
     * @return \Sabre\BargainFinderMax\Structs\Segment
     */
    public function setFlightIndex($flightIndex = null)
    {
        $this->FlightIndex = $flightIndex;
        return $this;
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Sabre\BargainFinderMax\Structs\Segment
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get iD_1 value
     * @return iD_1
     */
    public function getID_1()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \Sabre\BargainFinderMax\Structs\Segment
     */
    public function setID_1($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \Sabre\BargainFinderMax\Structs\Segment
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get ProgramID value
     * @return string|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \Sabre\BargainFinderMax\Structs\Segment
     */
    public function setProgramID($programID = null)
    {
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get ProgramCode value
     * @return string|null
     */
    public function getProgramCode()
    {
        return $this->ProgramCode;
    }
    /**
     * Set ProgramCode value
     * @param string $programCode
     * @return \Sabre\BargainFinderMax\Structs\Segment
     */
    public function setProgramCode($programCode = null)
    {
        $this->ProgramCode = $programCode;
        return $this;
    }
    /**
     * Get ProgramDescription value
     * @return string|null
     */
    public function getProgramDescription()
    {
        return $this->ProgramDescription;
    }
    /**
     * Set ProgramDescription value
     * @param string $programDescription
     * @return \Sabre\BargainFinderMax\Structs\Segment
     */
    public function setProgramDescription($programDescription = null)
    {
        $this->ProgramDescription = $programDescription;
        return $this;
    }
    /**
     * Get ProgramSystemCode value
     * @return string|null
     */
    public function getProgramSystemCode()
    {
        return $this->ProgramSystemCode;
    }
    /**
     * Set ProgramSystemCode value
     * @param string $programSystemCode
     * @return \Sabre\BargainFinderMax\Structs\Segment
     */
    public function setProgramSystemCode($programSystemCode = null)
    {
        $this->ProgramSystemCode = $programSystemCode;
        return $this;
    }
    /**
     * Get BrandID value
     * @return string|null
     */
    public function getBrandID()
    {
        return $this->BrandID;
    }
    /**
     * Set BrandID value
     * @param string $brandID
     * @return \Sabre\BargainFinderMax\Structs\Segment
     */
    public function setBrandID($brandID = null)
    {
        $this->BrandID = $brandID;
        return $this;
    }
    /**
     * Get BrandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param string $brandName
     * @return \Sabre\BargainFinderMax\Structs\Segment
     */
    public function setBrandName($brandName = null)
    {
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get FareStatus value
     * @return string|null
     */
    public function getFareStatus()
    {
        return $this->FareStatus;
    }
    /**
     * Set FareStatus value
     * @param string $fareStatus
     * @return \Sabre\BargainFinderMax\Structs\Segment
     */
    public function setFareStatus($fareStatus = null)
    {
        $this->FareStatus = $fareStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Segment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
