<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleInfoType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Contains summary fare rule information as well as detailed Rule Information for Fare Basis Codes. Information may be actual rules data or the results returned from a rules-based inquiry.
 * @subpackage Structs
 */
class RuleInfoType extends AbstractStructBase
{
    /**
     * The ResTicketingRules
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ResTicketingRules
     */
    public $ResTicketingRules;
    /**
     * The LengthOfStayRules
     * Meta informations extracted from the WSDL
     * - documentation: Rules providing minimum or maximum stay restrictions.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\StayRestrictionsType
     */
    public $LengthOfStayRules;
    /**
     * Constructor method for RuleInfoType
     * @uses RuleInfoType::setResTicketingRules()
     * @uses RuleInfoType::setLengthOfStayRules()
     * @param \Sabre\BargainFinderMax\Structs\ResTicketingRules $resTicketingRules
     * @param \Sabre\BargainFinderMax\Structs\StayRestrictionsType $lengthOfStayRules
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\ResTicketingRules $resTicketingRules = null, \Sabre\BargainFinderMax\Structs\StayRestrictionsType $lengthOfStayRules = null)
    {
        $this
            ->setResTicketingRules($resTicketingRules)
            ->setLengthOfStayRules($lengthOfStayRules);
    }
    /**
     * Get ResTicketingRules value
     * @return \Sabre\BargainFinderMax\Structs\ResTicketingRules|null
     */
    public function getResTicketingRules()
    {
        return $this->ResTicketingRules;
    }
    /**
     * Set ResTicketingRules value
     * @param \Sabre\BargainFinderMax\Structs\ResTicketingRules $resTicketingRules
     * @return \Sabre\BargainFinderMax\Structs\RuleInfoType
     */
    public function setResTicketingRules(\Sabre\BargainFinderMax\Structs\ResTicketingRules $resTicketingRules = null)
    {
        $this->ResTicketingRules = $resTicketingRules;
        return $this;
    }
    /**
     * Get LengthOfStayRules value
     * @return \Sabre\BargainFinderMax\Structs\StayRestrictionsType|null
     */
    public function getLengthOfStayRules()
    {
        return $this->LengthOfStayRules;
    }
    /**
     * Set LengthOfStayRules value
     * @param \Sabre\BargainFinderMax\Structs\StayRestrictionsType $lengthOfStayRules
     * @return \Sabre\BargainFinderMax\Structs\RuleInfoType
     */
    public function setLengthOfStayRules(\Sabre\BargainFinderMax\Structs\StayRestrictionsType $lengthOfStayRules = null)
    {
        $this->LengthOfStayRules = $lengthOfStayRules;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\RuleInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
