<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoutingLegType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Definition of individual routing legs, at least one leg must be present.
 * @subpackage Structs
 */
class RoutingLegType extends AbstractStructBase
{
    /**
     * The InboundOutboundCarrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - pattern: [A-Z0-9][A-Z][A-Z0-9]?
     * @var string[]
     */
    public $InboundOutboundCarrier;
    /**
     * The InboundCarrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - pattern: [A-Z0-9][A-Z][A-Z0-9]?
     * @var string[]
     */
    public $InboundCarrier;
    /**
     * The OutboundCarrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - pattern: [A-Z0-9][A-Z][A-Z0-9]?
     * @var string[]
     */
    public $OutboundCarrier;
    /**
     * The ConnectPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - pattern: [A-Z]{3,5}
     * @var string[]
     */
    public $ConnectPoint;
    /**
     * Constructor method for RoutingLegType
     * @uses RoutingLegType::setInboundOutboundCarrier()
     * @uses RoutingLegType::setInboundCarrier()
     * @uses RoutingLegType::setOutboundCarrier()
     * @uses RoutingLegType::setConnectPoint()
     * @param string[] $inboundOutboundCarrier
     * @param string[] $inboundCarrier
     * @param string[] $outboundCarrier
     * @param string[] $connectPoint
     */
    public function __construct(array $inboundOutboundCarrier = array(), array $inboundCarrier = array(), array $outboundCarrier = array(), array $connectPoint = array())
    {
        $this
            ->setInboundOutboundCarrier($inboundOutboundCarrier)
            ->setInboundCarrier($inboundCarrier)
            ->setOutboundCarrier($outboundCarrier)
            ->setConnectPoint($connectPoint);
    }
    /**
     * Get InboundOutboundCarrier value
     * @return string[]|null
     */
    public function getInboundOutboundCarrier()
    {
        return $this->InboundOutboundCarrier;
    }
    /**
     * Set InboundOutboundCarrier value
     * @throws \InvalidArgumentException
     * @param string[] $inboundOutboundCarrier
     * @return \Sabre\BargainFinderMax\Structs\RoutingLegType
     */
    public function setInboundOutboundCarrier(array $inboundOutboundCarrier = array())
    {
        $this->InboundOutboundCarrier = $inboundOutboundCarrier;
        return $this;
    }
    /**
     * Add item to InboundOutboundCarrier value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\BargainFinderMax\Structs\RoutingLegType
     */
    public function addToInboundOutboundCarrier($item)
    {
        $this->InboundOutboundCarrier[] = $item;
        return $this;
    }
    /**
     * Get InboundCarrier value
     * @return string[]|null
     */
    public function getInboundCarrier()
    {
        return $this->InboundCarrier;
    }
    /**
     * Set InboundCarrier value
     * @throws \InvalidArgumentException
     * @param string[] $inboundCarrier
     * @return \Sabre\BargainFinderMax\Structs\RoutingLegType
     */
    public function setInboundCarrier(array $inboundCarrier = array())
    {
        $this->InboundCarrier = $inboundCarrier;
        return $this;
    }
    /**
     * Add item to InboundCarrier value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\BargainFinderMax\Structs\RoutingLegType
     */
    public function addToInboundCarrier($item)
    {
        $this->InboundCarrier[] = $item;
        return $this;
    }
    /**
     * Get OutboundCarrier value
     * @return string[]|null
     */
    public function getOutboundCarrier()
    {
        return $this->OutboundCarrier;
    }
    /**
     * Set OutboundCarrier value
     * @throws \InvalidArgumentException
     * @param string[] $outboundCarrier
     * @return \Sabre\BargainFinderMax\Structs\RoutingLegType
     */
    public function setOutboundCarrier(array $outboundCarrier = array())
    {
        $this->OutboundCarrier = $outboundCarrier;
        return $this;
    }
    /**
     * Add item to OutboundCarrier value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\BargainFinderMax\Structs\RoutingLegType
     */
    public function addToOutboundCarrier($item)
    {
        $this->OutboundCarrier[] = $item;
        return $this;
    }
    /**
     * Get ConnectPoint value
     * @return string[]|null
     */
    public function getConnectPoint()
    {
        return $this->ConnectPoint;
    }
    /**
     * Set ConnectPoint value
     * @throws \InvalidArgumentException
     * @param string[] $connectPoint
     * @return \Sabre\BargainFinderMax\Structs\RoutingLegType
     */
    public function setConnectPoint(array $connectPoint = array())
    {
        $this->ConnectPoint = $connectPoint;
        return $this;
    }
    /**
     * Add item to ConnectPoint value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\BargainFinderMax\Structs\RoutingLegType
     */
    public function addToConnectPoint($item)
    {
        $this->ConnectPoint[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\RoutingLegType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
