<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReissueInfoList Structs
 * Meta informations extracted from the WSDL
 * - documentation: Reissue information
 * @subpackage Structs
 */
class ReissueInfoList extends AbstractStructBase
{
    /**
     * The ReissueInfo
     * Meta informations extracted from the WSDL
     * - documentation: Reissue Info
     * - maxOccurs: unbounded
     * @var \Sabre\BargainFinderMax\Structs\ReissueInfoType[]
     */
    public $ReissueInfo;
    /**
     * Constructor method for ReissueInfoList
     * @uses ReissueInfoList::setReissueInfo()
     * @param \Sabre\BargainFinderMax\Structs\ReissueInfoType[] $reissueInfo
     */
    public function __construct(array $reissueInfo = array())
    {
        $this
            ->setReissueInfo($reissueInfo);
    }
    /**
     * Get ReissueInfo value
     * @return \Sabre\BargainFinderMax\Structs\ReissueInfoType[]|null
     */
    public function getReissueInfo()
    {
        return $this->ReissueInfo;
    }
    /**
     * Set ReissueInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ReissueInfoType[] $reissueInfo
     * @return \Sabre\BargainFinderMax\Structs\ReissueInfoList
     */
    public function setReissueInfo(array $reissueInfo = array())
    {
        $this->ReissueInfo = $reissueInfo;
        return $this;
    }
    /**
     * Add item to ReissueInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ReissueInfoType $item
     * @return \Sabre\BargainFinderMax\Structs\ReissueInfoList
     */
    public function addToReissueInfo(\Sabre\BargainFinderMax\Structs\ReissueInfoType $item)
    {
        $this->ReissueInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ReissueInfoList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
