<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingInformationType Structs
 * @subpackage Structs
 */
class PricingInformationType extends AbstractStructBase
{
    /**
     * The Cached
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Cached
     */
    public $Cached;
    /**
     * The Fare
     * @var \Sabre\BargainFinderMax\Structs\FareType
     */
    public $Fare;
    /**
     * The SoldOut
     * @var \Sabre\BargainFinderMax\Structs\SoldOutType
     */
    public $SoldOut;
    /**
     * The Ticket
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $Ticket;
    /**
     * The PricingSubsource
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PricingSubsource;
    /**
     * The PseudoCityCode
     * Meta informations extracted from the WSDL
     * - documentation: (MultiPCC) Information about Pseudo City Code for wich the fare was produced. | Pseudo City Code, e.g.: "W0H3". One Itinerary can contain fares produced for more than one pseudo city code.
     * - use: optional
     * - maxLength: 4
     * - minLength: 3
     * - pattern: [A-Z0-9]+
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The PoSCountryCode
     * Meta informations extracted from the WSDL
     * - documentation: Point of sale country code (only populated for streaming aggregated shopping results). | Country code type
     * - use: optional
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $PoSCountryCode;
    /**
     * The PassengerGroup
     * Meta informations extracted from the WSDL
     * - documentation: (SAPT) Index of this passenger group in the request
     * - use: optional
     * @var int
     */
    public $PassengerGroup;
    /**
     * The FlexibleFare
     * Meta informations extracted from the WSDL
     * - documentation: If the fare is an additional flexible fare, this is the fare group ID
     * - use: optional
     * @var int
     */
    public $FlexibleFare;
    /**
     * The Brand
     * Meta informations extracted from the WSDL
     * - documentation: Brand ID
     * - use: optional
     * @var string
     */
    public $Brand;
    /**
     * The Program
     * Meta informations extracted from the WSDL
     * - documentation: Program/campaign ID, which the downline clients need to determine which marketing text to display.
     * - use: optional
     * @var string
     */
    public $Program;
    /**
     * The BrandsOnAnyMarket
     * Meta informations extracted from the WSDL
     * - documentation: True if itin has any brand on any fare market
     * - use: optional
     * @var bool
     */
    public $BrandsOnAnyMarket;
    /**
     * The Repriced
     * Meta informations extracted from the WSDL
     * - documentation: True if itin has been repriced in WPNI verification flow.
     * - use: optional
     * @var bool
     */
    public $Repriced;
    /**
     * Constructor method for PricingInformationType
     * @uses PricingInformationType::setCached()
     * @uses PricingInformationType::setFare()
     * @uses PricingInformationType::setSoldOut()
     * @uses PricingInformationType::setTicket()
     * @uses PricingInformationType::setPricingSubsource()
     * @uses PricingInformationType::setPseudoCityCode()
     * @uses PricingInformationType::setPoSCountryCode()
     * @uses PricingInformationType::setPassengerGroup()
     * @uses PricingInformationType::setFlexibleFare()
     * @uses PricingInformationType::setBrand()
     * @uses PricingInformationType::setProgram()
     * @uses PricingInformationType::setBrandsOnAnyMarket()
     * @uses PricingInformationType::setRepriced()
     * @param \Sabre\BargainFinderMax\Structs\Cached $cached
     * @param \Sabre\BargainFinderMax\Structs\FareType $fare
     * @param \Sabre\BargainFinderMax\Structs\SoldOutType $soldOut
     * @param string[] $ticket
     * @param string $pricingSubsource
     * @param string $pseudoCityCode
     * @param string $poSCountryCode
     * @param int $passengerGroup
     * @param int $flexibleFare
     * @param string $brand
     * @param string $program
     * @param bool $brandsOnAnyMarket
     * @param bool $repriced
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\Cached $cached = null, \Sabre\BargainFinderMax\Structs\FareType $fare = null, \Sabre\BargainFinderMax\Structs\SoldOutType $soldOut = null, array $ticket = array(), $pricingSubsource = null, $pseudoCityCode = null, $poSCountryCode = null, $passengerGroup = null, $flexibleFare = null, $brand = null, $program = null, $brandsOnAnyMarket = null, $repriced = null)
    {
        $this
            ->setCached($cached)
            ->setFare($fare)
            ->setSoldOut($soldOut)
            ->setTicket($ticket)
            ->setPricingSubsource($pricingSubsource)
            ->setPseudoCityCode($pseudoCityCode)
            ->setPoSCountryCode($poSCountryCode)
            ->setPassengerGroup($passengerGroup)
            ->setFlexibleFare($flexibleFare)
            ->setBrand($brand)
            ->setProgram($program)
            ->setBrandsOnAnyMarket($brandsOnAnyMarket)
            ->setRepriced($repriced);
    }
    /**
     * Get Cached value
     * @return \Sabre\BargainFinderMax\Structs\Cached|null
     */
    public function getCached()
    {
        return $this->Cached;
    }
    /**
     * Set Cached value
     * @param \Sabre\BargainFinderMax\Structs\Cached $cached
     * @return \Sabre\BargainFinderMax\Structs\PricingInformationType
     */
    public function setCached(\Sabre\BargainFinderMax\Structs\Cached $cached = null)
    {
        $this->Cached = $cached;
        return $this;
    }
    /**
     * Get Fare value
     * @return \Sabre\BargainFinderMax\Structs\FareType|null
     */
    public function getFare()
    {
        return $this->Fare;
    }
    /**
     * Set Fare value
     * @param \Sabre\BargainFinderMax\Structs\FareType $fare
     * @return \Sabre\BargainFinderMax\Structs\PricingInformationType
     */
    public function setFare(\Sabre\BargainFinderMax\Structs\FareType $fare = null)
    {
        $this->Fare = $fare;
        return $this;
    }
    /**
     * Get SoldOut value
     * @return \Sabre\BargainFinderMax\Structs\SoldOutType|null
     */
    public function getSoldOut()
    {
        return $this->SoldOut;
    }
    /**
     * Set SoldOut value
     * @param \Sabre\BargainFinderMax\Structs\SoldOutType $soldOut
     * @return \Sabre\BargainFinderMax\Structs\PricingInformationType
     */
    public function setSoldOut(\Sabre\BargainFinderMax\Structs\SoldOutType $soldOut = null)
    {
        $this->SoldOut = $soldOut;
        return $this;
    }
    /**
     * Get Ticket value
     * @return string[]|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @uses \Sabre\BargainFinderMax\Enums\TicketType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\TicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $ticket
     * @return \Sabre\BargainFinderMax\Structs\PricingInformationType
     */
    public function setTicket(array $ticket = array())
    {
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Add item to Ticket value
     * @uses \Sabre\BargainFinderMax\Enums\TicketType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\TicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\BargainFinderMax\Structs\PricingInformationType
     */
    public function addToTicket($item)
    {
        $this->Ticket[] = $item;
        return $this;
    }
    /**
     * Get PricingSubsource value
     * @return string|null
     */
    public function getPricingSubsource()
    {
        return $this->PricingSubsource;
    }
    /**
     * Set PricingSubsource value
     * @param string $pricingSubsource
     * @return \Sabre\BargainFinderMax\Structs\PricingInformationType
     */
    public function setPricingSubsource($pricingSubsource = null)
    {
        $this->PricingSubsource = $pricingSubsource;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \Sabre\BargainFinderMax\Structs\PricingInformationType
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get PoSCountryCode value
     * @return string|null
     */
    public function getPoSCountryCode()
    {
        return $this->PoSCountryCode;
    }
    /**
     * Set PoSCountryCode value
     * @param string $poSCountryCode
     * @return \Sabre\BargainFinderMax\Structs\PricingInformationType
     */
    public function setPoSCountryCode($poSCountryCode = null)
    {
        $this->PoSCountryCode = $poSCountryCode;
        return $this;
    }
    /**
     * Get PassengerGroup value
     * @return int|null
     */
    public function getPassengerGroup()
    {
        return $this->PassengerGroup;
    }
    /**
     * Set PassengerGroup value
     * @param int $passengerGroup
     * @return \Sabre\BargainFinderMax\Structs\PricingInformationType
     */
    public function setPassengerGroup($passengerGroup = null)
    {
        $this->PassengerGroup = $passengerGroup;
        return $this;
    }
    /**
     * Get FlexibleFare value
     * @return int|null
     */
    public function getFlexibleFare()
    {
        return $this->FlexibleFare;
    }
    /**
     * Set FlexibleFare value
     * @param int $flexibleFare
     * @return \Sabre\BargainFinderMax\Structs\PricingInformationType
     */
    public function setFlexibleFare($flexibleFare = null)
    {
        $this->FlexibleFare = $flexibleFare;
        return $this;
    }
    /**
     * Get Brand value
     * @return string|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @param string $brand
     * @return \Sabre\BargainFinderMax\Structs\PricingInformationType
     */
    public function setBrand($brand = null)
    {
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Get Program value
     * @return string|null
     */
    public function getProgram()
    {
        return $this->Program;
    }
    /**
     * Set Program value
     * @param string $program
     * @return \Sabre\BargainFinderMax\Structs\PricingInformationType
     */
    public function setProgram($program = null)
    {
        $this->Program = $program;
        return $this;
    }
    /**
     * Get BrandsOnAnyMarket value
     * @return bool|null
     */
    public function getBrandsOnAnyMarket()
    {
        return $this->BrandsOnAnyMarket;
    }
    /**
     * Set BrandsOnAnyMarket value
     * @param bool $brandsOnAnyMarket
     * @return \Sabre\BargainFinderMax\Structs\PricingInformationType
     */
    public function setBrandsOnAnyMarket($brandsOnAnyMarket = null)
    {
        $this->BrandsOnAnyMarket = $brandsOnAnyMarket;
        return $this;
    }
    /**
     * Get Repriced value
     * @return bool|null
     */
    public function getRepriced()
    {
        return $this->Repriced;
    }
    /**
     * Set Repriced value
     * @param bool $repriced
     * @return \Sabre\BargainFinderMax\Structs\PricingInformationType
     */
    public function setRepriced($repriced = null)
    {
        $this->Repriced = $repriced;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\PricingInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
