<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricedItineraryType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Itinerary with pricing information.
 * @subpackage Structs
 */
class PricedItineraryType extends AbstractStructBase
{
    /**
     * The SequenceNumber
     * Meta informations extracted from the WSDL
     * - documentation: Assigns a number to priced itineraries.
     * - use: required
     * @var int
     */
    public $SequenceNumber;
    /**
     * The AirItinerary
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the origin and destination of the traveler.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AirItineraryType
     */
    public $AirItinerary;
    /**
     * The AirItineraryPricingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfo[]
     */
    public $AirItineraryPricingInfo;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - documentation: Provides for free form descriptive information for the priced itinerary.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\FreeTextType[]
     */
    public $Notes;
    /**
     * The TicketingInfo
     * Meta informations extracted from the WSDL
     * - documentation: Container for TicketingInfoRS_Type.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type
     */
    public $TicketingInfo;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The isFromCustomPath
     * Meta informations extracted from the WSDL
     * - documentation: Indicates if itin come from custom carrier/routing path.
     * - use: optional
     * @var bool
     */
    public $isFromCustomPath;
    /**
     * The OriginDestinationRPH
     * Meta informations extracted from the WSDL
     * - documentation: When a PricedItinerary element contains flights and pricing information for a single OriginDestinationPair from the OTA_LowFareSearchRQ message, this RPH attribute identifies that OriginDestinationPair from the RQ. When the
     * PricedItinerary contains flights and pricing information for all OriginDestinationPairs from the OTA_LowFareSearchRQ message, this attribute should not be included. | (Reference Place Holder) - an index code to identify an instance in a collection of
     * like items.. For example, used to assign individual passengers or clients to particular itinerary items.
     * - use: optional
     * - pattern: [0-9]{1,8}
     * @var string
     */
    public $OriginDestinationRPH;
    /**
     * The CampaignID
     * Meta informations extracted from the WSDL
     * - documentation: Program/campaign ID, which the downline clients need to determine which marketing text to display.
     * - use: optional
     * @var string
     */
    public $CampaignID;
    /**
     * The AlternateAirport
     * Meta informations extracted from the WSDL
     * - documentation: Alternate airport itineraries indicator
     * - use: optional
     * @var bool
     */
    public $AlternateAirport;
    /**
     * The MultipleTickets
     * Meta informations extracted from the WSDL
     * - documentation: Indicates that itinerary should be sold on multiple separate tickets
     * - use: optional
     * @var bool
     */
    public $MultipleTickets;
    /**
     * Constructor method for PricedItineraryType
     * @uses PricedItineraryType::setSequenceNumber()
     * @uses PricedItineraryType::setAirItinerary()
     * @uses PricedItineraryType::setAirItineraryPricingInfo()
     * @uses PricedItineraryType::setNotes()
     * @uses PricedItineraryType::setTicketingInfo()
     * @uses PricedItineraryType::setTPA_Extensions()
     * @uses PricedItineraryType::setIsFromCustomPath()
     * @uses PricedItineraryType::setOriginDestinationRPH()
     * @uses PricedItineraryType::setCampaignID()
     * @uses PricedItineraryType::setAlternateAirport()
     * @uses PricedItineraryType::setMultipleTickets()
     * @param int $sequenceNumber
     * @param \Sabre\BargainFinderMax\Structs\AirItineraryType $airItinerary
     * @param \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfo[] $airItineraryPricingInfo
     * @param \Sabre\BargainFinderMax\Structs\FreeTextType[] $notes
     * @param \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type $ticketingInfo
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @param bool $isFromCustomPath
     * @param string $originDestinationRPH
     * @param string $campaignID
     * @param bool $alternateAirport
     * @param bool $multipleTickets
     */
    public function __construct($sequenceNumber = null, \Sabre\BargainFinderMax\Structs\AirItineraryType $airItinerary = null, array $airItineraryPricingInfo = array(), array $notes = array(), \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type $ticketingInfo = null, \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null, $isFromCustomPath = null, $originDestinationRPH = null, $campaignID = null, $alternateAirport = null, $multipleTickets = null)
    {
        $this
            ->setSequenceNumber($sequenceNumber)
            ->setAirItinerary($airItinerary)
            ->setAirItineraryPricingInfo($airItineraryPricingInfo)
            ->setNotes($notes)
            ->setTicketingInfo($ticketingInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setIsFromCustomPath($isFromCustomPath)
            ->setOriginDestinationRPH($originDestinationRPH)
            ->setCampaignID($campaignID)
            ->setAlternateAirport($alternateAirport)
            ->setMultipleTickets($multipleTickets);
    }
    /**
     * Get SequenceNumber value
     * @return int
     */
    public function getSequenceNumber()
    {
        return $this->SequenceNumber;
    }
    /**
     * Set SequenceNumber value
     * @param int $sequenceNumber
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraryType
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        $this->SequenceNumber = $sequenceNumber;
        return $this;
    }
    /**
     * Get AirItinerary value
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryType|null
     */
    public function getAirItinerary()
    {
        return $this->AirItinerary;
    }
    /**
     * Set AirItinerary value
     * @param \Sabre\BargainFinderMax\Structs\AirItineraryType $airItinerary
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraryType
     */
    public function setAirItinerary(\Sabre\BargainFinderMax\Structs\AirItineraryType $airItinerary = null)
    {
        $this->AirItinerary = $airItinerary;
        return $this;
    }
    /**
     * Get AirItineraryPricingInfo value
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfo[]|null
     */
    public function getAirItineraryPricingInfo()
    {
        return $this->AirItineraryPricingInfo;
    }
    /**
     * Set AirItineraryPricingInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfo[] $airItineraryPricingInfo
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraryType
     */
    public function setAirItineraryPricingInfo(array $airItineraryPricingInfo = array())
    {
        $this->AirItineraryPricingInfo = $airItineraryPricingInfo;
        return $this;
    }
    /**
     * Add item to AirItineraryPricingInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfo $item
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraryType
     */
    public function addToAirItineraryPricingInfo(\Sabre\BargainFinderMax\Structs\AirItineraryPricingInfo $item)
    {
        $this->AirItineraryPricingInfo[] = $item;
        return $this;
    }
    /**
     * Get Notes value
     * @return \Sabre\BargainFinderMax\Structs\FreeTextType[]|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FreeTextType[] $notes
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraryType
     */
    public function setNotes(array $notes = array())
    {
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Add item to Notes value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FreeTextType $item
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraryType
     */
    public function addToNotes(\Sabre\BargainFinderMax\Structs\FreeTextType $item)
    {
        $this->Notes[] = $item;
        return $this;
    }
    /**
     * Get TicketingInfo value
     * @return \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type|null
     */
    public function getTicketingInfo()
    {
        return $this->TicketingInfo;
    }
    /**
     * Set TicketingInfo value
     * @param \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type $ticketingInfo
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraryType
     */
    public function setTicketingInfo(\Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type $ticketingInfo = null)
    {
        $this->TicketingInfo = $ticketingInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \Sabre\BargainFinderMax\Structs\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraryType
     */
    public function setTPA_Extensions(\Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get isFromCustomPath value
     * @return bool|null
     */
    public function getIsFromCustomPath()
    {
        return $this->isFromCustomPath;
    }
    /**
     * Set isFromCustomPath value
     * @param bool $isFromCustomPath
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraryType
     */
    public function setIsFromCustomPath($isFromCustomPath = null)
    {
        $this->isFromCustomPath = $isFromCustomPath;
        return $this;
    }
    /**
     * Get OriginDestinationRPH value
     * @return string|null
     */
    public function getOriginDestinationRPH()
    {
        return $this->OriginDestinationRPH;
    }
    /**
     * Set OriginDestinationRPH value
     * @param string $originDestinationRPH
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraryType
     */
    public function setOriginDestinationRPH($originDestinationRPH = null)
    {
        $this->OriginDestinationRPH = $originDestinationRPH;
        return $this;
    }
    /**
     * Get CampaignID value
     * @return string|null
     */
    public function getCampaignID()
    {
        return $this->CampaignID;
    }
    /**
     * Set CampaignID value
     * @param string $campaignID
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraryType
     */
    public function setCampaignID($campaignID = null)
    {
        $this->CampaignID = $campaignID;
        return $this;
    }
    /**
     * Get AlternateAirport value
     * @return bool|null
     */
    public function getAlternateAirport()
    {
        return $this->AlternateAirport;
    }
    /**
     * Set AlternateAirport value
     * @param bool $alternateAirport
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraryType
     */
    public function setAlternateAirport($alternateAirport = null)
    {
        $this->AlternateAirport = $alternateAirport;
        return $this;
    }
    /**
     * Get MultipleTickets value
     * @return bool|null
     */
    public function getMultipleTickets()
    {
        return $this->MultipleTickets;
    }
    /**
     * Set MultipleTickets value
     * @param bool $multipleTickets
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraryType
     */
    public function setMultipleTickets($multipleTickets = null)
    {
        $this->MultipleTickets = $multipleTickets;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
