<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceRequestInformationType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Identify pricing source, if negotiated fares are requested and if it is a reprice request.
 * @subpackage Structs
 */
class PriceRequestInformationType extends AbstractStructBase
{
    /**
     * The NegotiatedFareCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\NegotiatedFareCode
     */
    public $NegotiatedFareCode;
    /**
     * The AccountCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AccountCode
     */
    public $AccountCode;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The FareQualifier
     * @var string
     */
    public $FareQualifier;
    /**
     * The NegotiatedFaresOnly
     * Meta informations extracted from the WSDL
     * - documentation: If set to true then returned fares need to match requested AcccountCode/CorpID on all fare components
     * @var bool
     */
    public $NegotiatedFaresOnly;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: Type of funds preferred for reviewing monetary values, in ISO 4217 codes. | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The PricingSource
     * Meta informations extracted from the WSDL
     * - documentation: It can be used to indicate whether the fare is public or private.
     * @var string
     */
    public $PricingSource;
    /**
     * The Reprice
     * @var bool
     */
    public $Reprice;
    /**
     * The ProcessThruFaresOnly
     * Meta informations extracted from the WSDL
     * - documentation: Activates processing of thru fares only.
     * @var bool
     */
    public $ProcessThruFaresOnly;
    /**
     * The PurchaseDate
     * Meta informations extracted from the WSDL
     * - documentation: Specify purchase date. Fares returned will be based on the purchase date.
     * @var string
     */
    public $PurchaseDate;
    /**
     * The PurchaseTime
     * Meta informations extracted from the WSDL
     * - documentation: Specify purchase time. Fares returned will be based on the purchase time.
     * @var string
     */
    public $PurchaseTime;
    /**
     * The NetFaresUsed
     * Meta informations extracted from the WSDL
     * - documentation: Set to true when exchange ticket uses net fare.
     * @var bool
     */
    public $NetFaresUsed;
    /**
     * The BypassAdvancePurchase
     * Meta informations extracted from the WSDL
     * - documentation: Controls advance purchase validation logic for repricing. Values 'T'/'F' can be used by AS, for TN the only valid option is 'N'.
     * @var string
     */
    public $BypassAdvancePurchase;
    /**
     * Constructor method for PriceRequestInformationType
     * @uses PriceRequestInformationType::setNegotiatedFareCode()
     * @uses PriceRequestInformationType::setAccountCode()
     * @uses PriceRequestInformationType::setTPA_Extensions()
     * @uses PriceRequestInformationType::setFareQualifier()
     * @uses PriceRequestInformationType::setNegotiatedFaresOnly()
     * @uses PriceRequestInformationType::setCurrencyCode()
     * @uses PriceRequestInformationType::setPricingSource()
     * @uses PriceRequestInformationType::setReprice()
     * @uses PriceRequestInformationType::setProcessThruFaresOnly()
     * @uses PriceRequestInformationType::setPurchaseDate()
     * @uses PriceRequestInformationType::setPurchaseTime()
     * @uses PriceRequestInformationType::setNetFaresUsed()
     * @uses PriceRequestInformationType::setBypassAdvancePurchase()
     * @param \Sabre\BargainFinderMax\Structs\NegotiatedFareCode $negotiatedFareCode
     * @param \Sabre\BargainFinderMax\Structs\AccountCode $accountCode
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @param string $fareQualifier
     * @param bool $negotiatedFaresOnly
     * @param string $currencyCode
     * @param string $pricingSource
     * @param bool $reprice
     * @param bool $processThruFaresOnly
     * @param string $purchaseDate
     * @param string $purchaseTime
     * @param bool $netFaresUsed
     * @param string $bypassAdvancePurchase
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\NegotiatedFareCode $negotiatedFareCode = null, \Sabre\BargainFinderMax\Structs\AccountCode $accountCode = null, \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null, $fareQualifier = null, $negotiatedFaresOnly = null, $currencyCode = null, $pricingSource = null, $reprice = null, $processThruFaresOnly = null, $purchaseDate = null, $purchaseTime = null, $netFaresUsed = null, $bypassAdvancePurchase = null)
    {
        $this
            ->setNegotiatedFareCode($negotiatedFareCode)
            ->setAccountCode($accountCode)
            ->setTPA_Extensions($tPA_Extensions)
            ->setFareQualifier($fareQualifier)
            ->setNegotiatedFaresOnly($negotiatedFaresOnly)
            ->setCurrencyCode($currencyCode)
            ->setPricingSource($pricingSource)
            ->setReprice($reprice)
            ->setProcessThruFaresOnly($processThruFaresOnly)
            ->setPurchaseDate($purchaseDate)
            ->setPurchaseTime($purchaseTime)
            ->setNetFaresUsed($netFaresUsed)
            ->setBypassAdvancePurchase($bypassAdvancePurchase);
    }
    /**
     * Get NegotiatedFareCode value
     * @return \Sabre\BargainFinderMax\Structs\NegotiatedFareCode|null
     */
    public function getNegotiatedFareCode()
    {
        return $this->NegotiatedFareCode;
    }
    /**
     * Set NegotiatedFareCode value
     * @param \Sabre\BargainFinderMax\Structs\NegotiatedFareCode $negotiatedFareCode
     * @return \Sabre\BargainFinderMax\Structs\PriceRequestInformationType
     */
    public function setNegotiatedFareCode(\Sabre\BargainFinderMax\Structs\NegotiatedFareCode $negotiatedFareCode = null)
    {
        $this->NegotiatedFareCode = $negotiatedFareCode;
        return $this;
    }
    /**
     * Get AccountCode value
     * @return \Sabre\BargainFinderMax\Structs\AccountCode|null
     */
    public function getAccountCode()
    {
        return $this->AccountCode;
    }
    /**
     * Set AccountCode value
     * @param \Sabre\BargainFinderMax\Structs\AccountCode $accountCode
     * @return \Sabre\BargainFinderMax\Structs\PriceRequestInformationType
     */
    public function setAccountCode(\Sabre\BargainFinderMax\Structs\AccountCode $accountCode = null)
    {
        $this->AccountCode = $accountCode;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \Sabre\BargainFinderMax\Structs\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\PriceRequestInformationType
     */
    public function setTPA_Extensions(\Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get FareQualifier value
     * @return string|null
     */
    public function getFareQualifier()
    {
        return $this->FareQualifier;
    }
    /**
     * Set FareQualifier value
     * @param string $fareQualifier
     * @return \Sabre\BargainFinderMax\Structs\PriceRequestInformationType
     */
    public function setFareQualifier($fareQualifier = null)
    {
        $this->FareQualifier = $fareQualifier;
        return $this;
    }
    /**
     * Get NegotiatedFaresOnly value
     * @return bool|null
     */
    public function getNegotiatedFaresOnly()
    {
        return $this->NegotiatedFaresOnly;
    }
    /**
     * Set NegotiatedFaresOnly value
     * @param bool $negotiatedFaresOnly
     * @return \Sabre\BargainFinderMax\Structs\PriceRequestInformationType
     */
    public function setNegotiatedFaresOnly($negotiatedFaresOnly = null)
    {
        $this->NegotiatedFaresOnly = $negotiatedFaresOnly;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\BargainFinderMax\Structs\PriceRequestInformationType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get PricingSource value
     * @return string|null
     */
    public function getPricingSource()
    {
        return $this->PricingSource;
    }
    /**
     * Set PricingSource value
     * @uses \Sabre\BargainFinderMax\Enums\RequestPricingSourceType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\RequestPricingSourceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricingSource
     * @return \Sabre\BargainFinderMax\Structs\PriceRequestInformationType
     */
    public function setPricingSource($pricingSource = null)
    {
        $this->PricingSource = $pricingSource;
        return $this;
    }
    /**
     * Get Reprice value
     * @return bool|null
     */
    public function getReprice()
    {
        return $this->Reprice;
    }
    /**
     * Set Reprice value
     * @param bool $reprice
     * @return \Sabre\BargainFinderMax\Structs\PriceRequestInformationType
     */
    public function setReprice($reprice = null)
    {
        $this->Reprice = $reprice;
        return $this;
    }
    /**
     * Get ProcessThruFaresOnly value
     * @return bool|null
     */
    public function getProcessThruFaresOnly()
    {
        return $this->ProcessThruFaresOnly;
    }
    /**
     * Set ProcessThruFaresOnly value
     * @param bool $processThruFaresOnly
     * @return \Sabre\BargainFinderMax\Structs\PriceRequestInformationType
     */
    public function setProcessThruFaresOnly($processThruFaresOnly = null)
    {
        $this->ProcessThruFaresOnly = $processThruFaresOnly;
        return $this;
    }
    /**
     * Get PurchaseDate value
     * @return string|null
     */
    public function getPurchaseDate()
    {
        return $this->PurchaseDate;
    }
    /**
     * Set PurchaseDate value
     * @param string $purchaseDate
     * @return \Sabre\BargainFinderMax\Structs\PriceRequestInformationType
     */
    public function setPurchaseDate($purchaseDate = null)
    {
        $this->PurchaseDate = $purchaseDate;
        return $this;
    }
    /**
     * Get PurchaseTime value
     * @return string|null
     */
    public function getPurchaseTime()
    {
        return $this->PurchaseTime;
    }
    /**
     * Set PurchaseTime value
     * @param string $purchaseTime
     * @return \Sabre\BargainFinderMax\Structs\PriceRequestInformationType
     */
    public function setPurchaseTime($purchaseTime = null)
    {
        $this->PurchaseTime = $purchaseTime;
        return $this;
    }
    /**
     * Get NetFaresUsed value
     * @return bool|null
     */
    public function getNetFaresUsed()
    {
        return $this->NetFaresUsed;
    }
    /**
     * Set NetFaresUsed value
     * @param bool $netFaresUsed
     * @return \Sabre\BargainFinderMax\Structs\PriceRequestInformationType
     */
    public function setNetFaresUsed($netFaresUsed = null)
    {
        $this->NetFaresUsed = $netFaresUsed;
        return $this;
    }
    /**
     * Get BypassAdvancePurchase value
     * @return string|null
     */
    public function getBypassAdvancePurchase()
    {
        return $this->BypassAdvancePurchase;
    }
    /**
     * Set BypassAdvancePurchase value
     * @uses \Sabre\BargainFinderMax\Enums\BypassAdvancePurchaseType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\BypassAdvancePurchaseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bypassAdvancePurchase
     * @return \Sabre\BargainFinderMax\Structs\PriceRequestInformationType
     */
    public function setBypassAdvancePurchase($bypassAdvancePurchase = null)
    {
        $this->BypassAdvancePurchase = $bypassAdvancePurchase;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\PriceRequestInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
