<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlusUpType Structs
 * @subpackage Structs
 */
class PlusUpType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Amount | Used for amounts, max 3 decimals
     * - use: required
     * - fractionDigits: 3
     * @var float
     */
    public $Amount;
    /**
     * The OriginCity
     * Meta informations extracted from the WSDL
     * - documentation: Origin City | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - use: required
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $OriginCity;
    /**
     * The DestinationCity
     * Meta informations extracted from the WSDL
     * - documentation: Destination City | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - use: required
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $DestinationCity;
    /**
     * The FareOriginCity
     * Meta informations extracted from the WSDL
     * - documentation: Fare Origin City | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - use: optional
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $FareOriginCity;
    /**
     * The FareDestinationCity
     * Meta informations extracted from the WSDL
     * - documentation: Fare Destination City | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - use: optional
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $FareDestinationCity;
    /**
     * The ViaCity
     * Meta informations extracted from the WSDL
     * - documentation: Via City | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - use: optional
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $ViaCity;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - documentation: Message
     * - use: optional
     * @var string
     */
    public $Message;
    /**
     * The CountryOfPayment
     * Meta informations extracted from the WSDL
     * - documentation: Country of payment | 2 character country code as defined in ISO3166.
     * - use: optional
     * - pattern: [a-zA-Z]{2}
     * @var string
     */
    public $CountryOfPayment;
    /**
     * Constructor method for PlusUpType
     * @uses PlusUpType::setAmount()
     * @uses PlusUpType::setOriginCity()
     * @uses PlusUpType::setDestinationCity()
     * @uses PlusUpType::setFareOriginCity()
     * @uses PlusUpType::setFareDestinationCity()
     * @uses PlusUpType::setViaCity()
     * @uses PlusUpType::setMessage()
     * @uses PlusUpType::setCountryOfPayment()
     * @param float $amount
     * @param string $originCity
     * @param string $destinationCity
     * @param string $fareOriginCity
     * @param string $fareDestinationCity
     * @param string $viaCity
     * @param string $message
     * @param string $countryOfPayment
     */
    public function __construct($amount = null, $originCity = null, $destinationCity = null, $fareOriginCity = null, $fareDestinationCity = null, $viaCity = null, $message = null, $countryOfPayment = null)
    {
        $this
            ->setAmount($amount)
            ->setOriginCity($originCity)
            ->setDestinationCity($destinationCity)
            ->setFareOriginCity($fareOriginCity)
            ->setFareDestinationCity($fareDestinationCity)
            ->setViaCity($viaCity)
            ->setMessage($message)
            ->setCountryOfPayment($countryOfPayment);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Sabre\BargainFinderMax\Structs\PlusUpType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get OriginCity value
     * @return string
     */
    public function getOriginCity()
    {
        return $this->OriginCity;
    }
    /**
     * Set OriginCity value
     * @param string $originCity
     * @return \Sabre\BargainFinderMax\Structs\PlusUpType
     */
    public function setOriginCity($originCity = null)
    {
        $this->OriginCity = $originCity;
        return $this;
    }
    /**
     * Get DestinationCity value
     * @return string
     */
    public function getDestinationCity()
    {
        return $this->DestinationCity;
    }
    /**
     * Set DestinationCity value
     * @param string $destinationCity
     * @return \Sabre\BargainFinderMax\Structs\PlusUpType
     */
    public function setDestinationCity($destinationCity = null)
    {
        $this->DestinationCity = $destinationCity;
        return $this;
    }
    /**
     * Get FareOriginCity value
     * @return string|null
     */
    public function getFareOriginCity()
    {
        return $this->FareOriginCity;
    }
    /**
     * Set FareOriginCity value
     * @param string $fareOriginCity
     * @return \Sabre\BargainFinderMax\Structs\PlusUpType
     */
    public function setFareOriginCity($fareOriginCity = null)
    {
        $this->FareOriginCity = $fareOriginCity;
        return $this;
    }
    /**
     * Get FareDestinationCity value
     * @return string|null
     */
    public function getFareDestinationCity()
    {
        return $this->FareDestinationCity;
    }
    /**
     * Set FareDestinationCity value
     * @param string $fareDestinationCity
     * @return \Sabre\BargainFinderMax\Structs\PlusUpType
     */
    public function setFareDestinationCity($fareDestinationCity = null)
    {
        $this->FareDestinationCity = $fareDestinationCity;
        return $this;
    }
    /**
     * Get ViaCity value
     * @return string|null
     */
    public function getViaCity()
    {
        return $this->ViaCity;
    }
    /**
     * Set ViaCity value
     * @param string $viaCity
     * @return \Sabre\BargainFinderMax\Structs\PlusUpType
     */
    public function setViaCity($viaCity = null)
    {
        $this->ViaCity = $viaCity;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Sabre\BargainFinderMax\Structs\PlusUpType
     */
    public function setMessage($message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Get CountryOfPayment value
     * @return string|null
     */
    public function getCountryOfPayment()
    {
        return $this->CountryOfPayment;
    }
    /**
     * Set CountryOfPayment value
     * @param string $countryOfPayment
     * @return \Sabre\BargainFinderMax\Structs\PlusUpType
     */
    public function setCountryOfPayment($countryOfPayment = null)
    {
        $this->CountryOfPayment = $countryOfPayment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\PlusUpType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
