<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerTotalFareType Structs
 * @subpackage Structs
 */
class PassengerTotalFareType extends AbstractStructBase
{
    /**
     * The TotalFare
     * Meta informations extracted from the WSDL
     * - documentation: Total fare per passenger
     * - use: required
     * @var float
     */
    public $TotalFare;
    /**
     * The TotalTaxes
     * Meta informations extracted from the WSDL
     * - documentation: Total taxes
     * - use: required
     * @var float
     */
    public $TotalTaxes;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - documentation: Currency code | Currency Code type
     * - use: required | optional
     * - pattern: [A-Z]{3}
     * - type: CurrencyCodeType
     * @var string
     */
    public $Currency;
    /**
     * The BaseFareAmount
     * Meta informations extracted from the WSDL
     * - documentation: Base fare amount
     * - use: optional
     * @var float
     */
    public $BaseFareAmount;
    /**
     * The BaseFareCurrency
     * Meta informations extracted from the WSDL
     * - documentation: Base fare currency code | Currency Code type
     * - use: optional | optional
     * - pattern: [A-Z]{3}
     * - type: CurrencyCodeType
     * @var string
     */
    public $BaseFareCurrency;
    /**
     * The EquivalentAmount
     * Meta informations extracted from the WSDL
     * - documentation: Equivalent amount - includes taxes and additional charges
     * - use: optional
     * @var float
     */
    public $EquivalentAmount;
    /**
     * The EquivalentCurrency
     * Meta informations extracted from the WSDL
     * - documentation: Equivalent currency code | Currency Code type
     * - use: optional | optional
     * - pattern: [A-Z]{3}
     * - type: CurrencyCodeType
     * @var string
     */
    public $EquivalentCurrency;
    /**
     * The ConstructionAmount
     * Meta informations extracted from the WSDL
     * - documentation: Construction total amount
     * - use: optional
     * @var float
     */
    public $ConstructionAmount;
    /**
     * The ConstructionCurrency
     * Meta informations extracted from the WSDL
     * - documentation: Construction currency code | Currency Code type
     * - use: optional | optional
     * - pattern: [A-Z]{3}
     * - type: CurrencyCodeType
     * @var string
     */
    public $ConstructionCurrency;
    /**
     * The StopoverCharges
     * Meta informations extracted from the WSDL
     * - documentation: Stopover charges / unspecified
     * - use: optional
     * @var float
     */
    public $StopoverCharges;
    /**
     * The CommissionPercentage
     * Meta informations extracted from the WSDL
     * - documentation: Commission percentage
     * - use: optional
     * @var float
     */
    public $CommissionPercentage;
    /**
     * The CommissionAmount
     * Meta informations extracted from the WSDL
     * - documentation: Commission amount
     * - use: optional
     * @var float
     */
    public $CommissionAmount;
    /**
     * The ExchangeRateOne
     * Meta informations extracted from the WSDL
     * - documentation: Exchange Rate One - exchange course from base fare and taxes amount to equivalent amount.
     * - use: optional
     * @var float
     */
    public $ExchangeRateOne;
    /**
     * The TotalTTypeOBFee
     * Meta informations extracted from the WSDL
     * - documentation: Total T-type OB Fee per passenger
     * - use: optional
     * @var float
     */
    public $TotalTTypeOBFee;
    /**
     * The Cat35CommissionPercentage
     * Meta informations extracted from the WSDL
     * - documentation: Cat 35 Commission Percentage
     * - use: optional
     * @var float
     */
    public $Cat35CommissionPercentage;
    /**
     * The Cat35CommissionAmount
     * Meta informations extracted from the WSDL
     * - documentation: Cat 35 Commission Amount
     * - use: optional
     * @var float
     */
    public $Cat35CommissionAmount;
    /**
     * The Cat35MarkupAmount
     * Meta informations extracted from the WSDL
     * - documentation: Cat 35 Markup Amount in equivalent amount currency
     * - use: optional
     * @var float
     */
    public $Cat35MarkupAmount;
    /**
     * The CommissionAmountInEquivalent
     * Meta informations extracted from the WSDL
     * - documentation: Commission Amount in equivalent amount currency
     * - use: optional
     * @var float
     */
    public $CommissionAmountInEquivalent;
    /**
     * The EffectivePriceDeviation
     * Meta informations extracted from the WSDL
     * - documentation: Effective Price Deviation
     * - use: optional
     * @var float
     */
    public $EffectivePriceDeviation;
    /**
     * The EffectiveDeviationType
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $EffectiveDeviationType;
    /**
     * The CommissionSource
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CommissionSource;
    /**
     * Constructor method for PassengerTotalFareType
     * @uses PassengerTotalFareType::setTotalFare()
     * @uses PassengerTotalFareType::setTotalTaxes()
     * @uses PassengerTotalFareType::setCurrency()
     * @uses PassengerTotalFareType::setBaseFareAmount()
     * @uses PassengerTotalFareType::setBaseFareCurrency()
     * @uses PassengerTotalFareType::setEquivalentAmount()
     * @uses PassengerTotalFareType::setEquivalentCurrency()
     * @uses PassengerTotalFareType::setConstructionAmount()
     * @uses PassengerTotalFareType::setConstructionCurrency()
     * @uses PassengerTotalFareType::setStopoverCharges()
     * @uses PassengerTotalFareType::setCommissionPercentage()
     * @uses PassengerTotalFareType::setCommissionAmount()
     * @uses PassengerTotalFareType::setExchangeRateOne()
     * @uses PassengerTotalFareType::setTotalTTypeOBFee()
     * @uses PassengerTotalFareType::setCat35CommissionPercentage()
     * @uses PassengerTotalFareType::setCat35CommissionAmount()
     * @uses PassengerTotalFareType::setCat35MarkupAmount()
     * @uses PassengerTotalFareType::setCommissionAmountInEquivalent()
     * @uses PassengerTotalFareType::setEffectivePriceDeviation()
     * @uses PassengerTotalFareType::setEffectiveDeviationType()
     * @uses PassengerTotalFareType::setCommissionSource()
     * @param float $totalFare
     * @param float $totalTaxes
     * @param string $currency
     * @param float $baseFareAmount
     * @param string $baseFareCurrency
     * @param float $equivalentAmount
     * @param string $equivalentCurrency
     * @param float $constructionAmount
     * @param string $constructionCurrency
     * @param float $stopoverCharges
     * @param float $commissionPercentage
     * @param float $commissionAmount
     * @param float $exchangeRateOne
     * @param float $totalTTypeOBFee
     * @param float $cat35CommissionPercentage
     * @param float $cat35CommissionAmount
     * @param float $cat35MarkupAmount
     * @param float $commissionAmountInEquivalent
     * @param float $effectivePriceDeviation
     * @param string $effectiveDeviationType
     * @param string $commissionSource
     */
    public function __construct($totalFare = null, $totalTaxes = null, $currency = null, $baseFareAmount = null, $baseFareCurrency = null, $equivalentAmount = null, $equivalentCurrency = null, $constructionAmount = null, $constructionCurrency = null, $stopoverCharges = null, $commissionPercentage = null, $commissionAmount = null, $exchangeRateOne = null, $totalTTypeOBFee = null, $cat35CommissionPercentage = null, $cat35CommissionAmount = null, $cat35MarkupAmount = null, $commissionAmountInEquivalent = null, $effectivePriceDeviation = null, $effectiveDeviationType = null, $commissionSource = null)
    {
        $this
            ->setTotalFare($totalFare)
            ->setTotalTaxes($totalTaxes)
            ->setCurrency($currency)
            ->setBaseFareAmount($baseFareAmount)
            ->setBaseFareCurrency($baseFareCurrency)
            ->setEquivalentAmount($equivalentAmount)
            ->setEquivalentCurrency($equivalentCurrency)
            ->setConstructionAmount($constructionAmount)
            ->setConstructionCurrency($constructionCurrency)
            ->setStopoverCharges($stopoverCharges)
            ->setCommissionPercentage($commissionPercentage)
            ->setCommissionAmount($commissionAmount)
            ->setExchangeRateOne($exchangeRateOne)
            ->setTotalTTypeOBFee($totalTTypeOBFee)
            ->setCat35CommissionPercentage($cat35CommissionPercentage)
            ->setCat35CommissionAmount($cat35CommissionAmount)
            ->setCat35MarkupAmount($cat35MarkupAmount)
            ->setCommissionAmountInEquivalent($commissionAmountInEquivalent)
            ->setEffectivePriceDeviation($effectivePriceDeviation)
            ->setEffectiveDeviationType($effectiveDeviationType)
            ->setCommissionSource($commissionSource);
    }
    /**
     * Get TotalFare value
     * @return float
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * Set TotalFare value
     * @param float $totalFare
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setTotalFare($totalFare = null)
    {
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Get TotalTaxes value
     * @return float
     */
    public function getTotalTaxes()
    {
        return $this->TotalTaxes;
    }
    /**
     * Set TotalTaxes value
     * @param float $totalTaxes
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setTotalTaxes($totalTaxes = null)
    {
        $this->TotalTaxes = $totalTaxes;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setCurrency($currency = null)
    {
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get BaseFareAmount value
     * @return float|null
     */
    public function getBaseFareAmount()
    {
        return $this->BaseFareAmount;
    }
    /**
     * Set BaseFareAmount value
     * @param float $baseFareAmount
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setBaseFareAmount($baseFareAmount = null)
    {
        $this->BaseFareAmount = $baseFareAmount;
        return $this;
    }
    /**
     * Get BaseFareCurrency value
     * @return string|null
     */
    public function getBaseFareCurrency()
    {
        return $this->BaseFareCurrency;
    }
    /**
     * Set BaseFareCurrency value
     * @param string $baseFareCurrency
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setBaseFareCurrency($baseFareCurrency = null)
    {
        $this->BaseFareCurrency = $baseFareCurrency;
        return $this;
    }
    /**
     * Get EquivalentAmount value
     * @return float|null
     */
    public function getEquivalentAmount()
    {
        return $this->EquivalentAmount;
    }
    /**
     * Set EquivalentAmount value
     * @param float $equivalentAmount
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setEquivalentAmount($equivalentAmount = null)
    {
        $this->EquivalentAmount = $equivalentAmount;
        return $this;
    }
    /**
     * Get EquivalentCurrency value
     * @return string|null
     */
    public function getEquivalentCurrency()
    {
        return $this->EquivalentCurrency;
    }
    /**
     * Set EquivalentCurrency value
     * @param string $equivalentCurrency
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setEquivalentCurrency($equivalentCurrency = null)
    {
        $this->EquivalentCurrency = $equivalentCurrency;
        return $this;
    }
    /**
     * Get ConstructionAmount value
     * @return float|null
     */
    public function getConstructionAmount()
    {
        return $this->ConstructionAmount;
    }
    /**
     * Set ConstructionAmount value
     * @param float $constructionAmount
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setConstructionAmount($constructionAmount = null)
    {
        $this->ConstructionAmount = $constructionAmount;
        return $this;
    }
    /**
     * Get ConstructionCurrency value
     * @return string|null
     */
    public function getConstructionCurrency()
    {
        return $this->ConstructionCurrency;
    }
    /**
     * Set ConstructionCurrency value
     * @param string $constructionCurrency
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setConstructionCurrency($constructionCurrency = null)
    {
        $this->ConstructionCurrency = $constructionCurrency;
        return $this;
    }
    /**
     * Get StopoverCharges value
     * @return float|null
     */
    public function getStopoverCharges()
    {
        return $this->StopoverCharges;
    }
    /**
     * Set StopoverCharges value
     * @param float $stopoverCharges
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setStopoverCharges($stopoverCharges = null)
    {
        $this->StopoverCharges = $stopoverCharges;
        return $this;
    }
    /**
     * Get CommissionPercentage value
     * @return float|null
     */
    public function getCommissionPercentage()
    {
        return $this->CommissionPercentage;
    }
    /**
     * Set CommissionPercentage value
     * @param float $commissionPercentage
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setCommissionPercentage($commissionPercentage = null)
    {
        $this->CommissionPercentage = $commissionPercentage;
        return $this;
    }
    /**
     * Get CommissionAmount value
     * @return float|null
     */
    public function getCommissionAmount()
    {
        return $this->CommissionAmount;
    }
    /**
     * Set CommissionAmount value
     * @param float $commissionAmount
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setCommissionAmount($commissionAmount = null)
    {
        $this->CommissionAmount = $commissionAmount;
        return $this;
    }
    /**
     * Get ExchangeRateOne value
     * @return float|null
     */
    public function getExchangeRateOne()
    {
        return $this->ExchangeRateOne;
    }
    /**
     * Set ExchangeRateOne value
     * @param float $exchangeRateOne
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setExchangeRateOne($exchangeRateOne = null)
    {
        $this->ExchangeRateOne = $exchangeRateOne;
        return $this;
    }
    /**
     * Get TotalTTypeOBFee value
     * @return float|null
     */
    public function getTotalTTypeOBFee()
    {
        return $this->TotalTTypeOBFee;
    }
    /**
     * Set TotalTTypeOBFee value
     * @param float $totalTTypeOBFee
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setTotalTTypeOBFee($totalTTypeOBFee = null)
    {
        $this->TotalTTypeOBFee = $totalTTypeOBFee;
        return $this;
    }
    /**
     * Get Cat35CommissionPercentage value
     * @return float|null
     */
    public function getCat35CommissionPercentage()
    {
        return $this->Cat35CommissionPercentage;
    }
    /**
     * Set Cat35CommissionPercentage value
     * @param float $cat35CommissionPercentage
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setCat35CommissionPercentage($cat35CommissionPercentage = null)
    {
        $this->Cat35CommissionPercentage = $cat35CommissionPercentage;
        return $this;
    }
    /**
     * Get Cat35CommissionAmount value
     * @return float|null
     */
    public function getCat35CommissionAmount()
    {
        return $this->Cat35CommissionAmount;
    }
    /**
     * Set Cat35CommissionAmount value
     * @param float $cat35CommissionAmount
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setCat35CommissionAmount($cat35CommissionAmount = null)
    {
        $this->Cat35CommissionAmount = $cat35CommissionAmount;
        return $this;
    }
    /**
     * Get Cat35MarkupAmount value
     * @return float|null
     */
    public function getCat35MarkupAmount()
    {
        return $this->Cat35MarkupAmount;
    }
    /**
     * Set Cat35MarkupAmount value
     * @param float $cat35MarkupAmount
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setCat35MarkupAmount($cat35MarkupAmount = null)
    {
        $this->Cat35MarkupAmount = $cat35MarkupAmount;
        return $this;
    }
    /**
     * Get CommissionAmountInEquivalent value
     * @return float|null
     */
    public function getCommissionAmountInEquivalent()
    {
        return $this->CommissionAmountInEquivalent;
    }
    /**
     * Set CommissionAmountInEquivalent value
     * @param float $commissionAmountInEquivalent
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setCommissionAmountInEquivalent($commissionAmountInEquivalent = null)
    {
        $this->CommissionAmountInEquivalent = $commissionAmountInEquivalent;
        return $this;
    }
    /**
     * Get EffectivePriceDeviation value
     * @return float|null
     */
    public function getEffectivePriceDeviation()
    {
        return $this->EffectivePriceDeviation;
    }
    /**
     * Set EffectivePriceDeviation value
     * @param float $effectivePriceDeviation
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setEffectivePriceDeviation($effectivePriceDeviation = null)
    {
        $this->EffectivePriceDeviation = $effectivePriceDeviation;
        return $this;
    }
    /**
     * Get EffectiveDeviationType value
     * @return string|null
     */
    public function getEffectiveDeviationType()
    {
        return $this->EffectiveDeviationType;
    }
    /**
     * Set EffectiveDeviationType value
     * @param string $effectiveDeviationType
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setEffectiveDeviationType($effectiveDeviationType = null)
    {
        $this->EffectiveDeviationType = $effectiveDeviationType;
        return $this;
    }
    /**
     * Get CommissionSource value
     * @return string|null
     */
    public function getCommissionSource()
    {
        return $this->CommissionSource;
    }
    /**
     * Set CommissionSource value
     * @param string $commissionSource
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public function setCommissionSource($commissionSource = null)
    {
        $this->CommissionSource = $commissionSource;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\PassengerTotalFareType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
