<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerStatus Structs
 * @subpackage Structs
 */
class PassengerStatus extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The StateCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: The postal service standard code or abbreviation for the state, province, or region. | Used for Character Strings, length 1 to 8
     * - minLength: 2 | 1
     * - maxLength: 8
     * @var string
     */
    public $StateCode;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - documentation: 2 character country code as defined in ISO3166.
     * - pattern: [a-zA-Z]{2}
     * @var string
     */
    public $CountryCode;
    /**
     * The CityCode
     * Meta informations extracted from the WSDL
     * - documentation: Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CityCode;
    /**
     * Constructor method for PassengerStatus
     * @uses PassengerStatus::setType()
     * @uses PassengerStatus::setStateCode()
     * @uses PassengerStatus::setCountryCode()
     * @uses PassengerStatus::setCityCode()
     * @param string $type
     * @param string $stateCode
     * @param string $countryCode
     * @param string $cityCode
     */
    public function __construct($type = null, $stateCode = null, $countryCode = null, $cityCode = null)
    {
        $this
            ->setType($type)
            ->setStateCode($stateCode)
            ->setCountryCode($countryCode)
            ->setCityCode($cityCode);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\BargainFinderMax\Structs\PassengerStatus
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get StateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->StateCode;
    }
    /**
     * Set StateCode value
     * @param string $stateCode
     * @return \Sabre\BargainFinderMax\Structs\PassengerStatus
     */
    public function setStateCode($stateCode = null)
    {
        $this->StateCode = $stateCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \Sabre\BargainFinderMax\Structs\PassengerStatus
     */
    public function setCountryCode($countryCode = null)
    {
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get CityCode value
     * @return string|null
     */
    public function getCityCode()
    {
        return $this->CityCode;
    }
    /**
     * Set CityCode value
     * @param string $cityCode
     * @return \Sabre\BargainFinderMax\Structs\PassengerStatus
     */
    public function setCityCode($cityCode = null)
    {
        $this->CityCode = $cityCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\PassengerStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
