<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PTCFareBreakdownType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Per passenger type code pricing for this itinerary. Set if fareBreakdown was requested.
 * @subpackage Structs
 */
class PTCFareBreakdownType extends AbstractStructBase
{
    /**
     * The PassengerTypeQuantity
     * Meta informations extracted from the WSDL
     * - documentation: Number of individuals traveling under this PTC
     * @var \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType
     */
    public $PassengerTypeQuantity;
    /**
     * The FareBasisCodes
     * @var \Sabre\BargainFinderMax\Structs\FareBasisCodes
     */
    public $FareBasisCodes;
    /**
     * The PassengerFare
     * Meta informations extracted from the WSDL
     * - documentation: The total passenger fare with cost breakdown.
     * @var \Sabre\BargainFinderMax\Structs\FareType
     */
    public $PassengerFare;
    /**
     * The Endorsements
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Endorsements
     */
    public $Endorsements;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The FareInfos
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\FareInfos
     */
    public $FareInfos;
    /**
     * The PricingSource
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether the fare is public or private. | It can be used to indicate whether the fare is public or private.
     * - use: optional
     * - pattern: [0-9A-Z_]{1,13}
     * @var string
     */
    public $PricingSource;
    /**
     * The PrivateFareType
     * @var string
     */
    public $PrivateFareType;
    /**
     * The LastTicketDate
     * Meta informations extracted from the WSDL
     * - documentation: Last day to ticket. | Allows for the specification of a date time or just time.
     * - union: string | time
     * @var string
     */
    public $LastTicketDate;
    /**
     * The PreviousExchangeDate
     * Meta informations extracted from the WSDL
     * - documentation: Previous Exchange Date
     * @var string
     */
    public $PreviousExchangeDate;
    /**
     * The ReissueExchange
     * @var string
     */
    public $ReissueExchange;
    /**
     * Constructor method for PTCFareBreakdownType
     * @uses PTCFareBreakdownType::setPassengerTypeQuantity()
     * @uses PTCFareBreakdownType::setFareBasisCodes()
     * @uses PTCFareBreakdownType::setPassengerFare()
     * @uses PTCFareBreakdownType::setEndorsements()
     * @uses PTCFareBreakdownType::setTPA_Extensions()
     * @uses PTCFareBreakdownType::setFareInfos()
     * @uses PTCFareBreakdownType::setPricingSource()
     * @uses PTCFareBreakdownType::setPrivateFareType()
     * @uses PTCFareBreakdownType::setLastTicketDate()
     * @uses PTCFareBreakdownType::setPreviousExchangeDate()
     * @uses PTCFareBreakdownType::setReissueExchange()
     * @param \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType $passengerTypeQuantity
     * @param \Sabre\BargainFinderMax\Structs\FareBasisCodes $fareBasisCodes
     * @param \Sabre\BargainFinderMax\Structs\FareType $passengerFare
     * @param \Sabre\BargainFinderMax\Structs\Endorsements $endorsements
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @param \Sabre\BargainFinderMax\Structs\FareInfos $fareInfos
     * @param string $pricingSource
     * @param string $privateFareType
     * @param string $lastTicketDate
     * @param string $previousExchangeDate
     * @param string $reissueExchange
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType $passengerTypeQuantity = null, \Sabre\BargainFinderMax\Structs\FareBasisCodes $fareBasisCodes = null, \Sabre\BargainFinderMax\Structs\FareType $passengerFare = null, \Sabre\BargainFinderMax\Structs\Endorsements $endorsements = null, \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null, \Sabre\BargainFinderMax\Structs\FareInfos $fareInfos = null, $pricingSource = null, $privateFareType = null, $lastTicketDate = null, $previousExchangeDate = null, $reissueExchange = null)
    {
        $this
            ->setPassengerTypeQuantity($passengerTypeQuantity)
            ->setFareBasisCodes($fareBasisCodes)
            ->setPassengerFare($passengerFare)
            ->setEndorsements($endorsements)
            ->setTPA_Extensions($tPA_Extensions)
            ->setFareInfos($fareInfos)
            ->setPricingSource($pricingSource)
            ->setPrivateFareType($privateFareType)
            ->setLastTicketDate($lastTicketDate)
            ->setPreviousExchangeDate($previousExchangeDate)
            ->setReissueExchange($reissueExchange);
    }
    /**
     * Get PassengerTypeQuantity value
     * @return \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType|null
     */
    public function getPassengerTypeQuantity()
    {
        return $this->PassengerTypeQuantity;
    }
    /**
     * Set PassengerTypeQuantity value
     * @param \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType $passengerTypeQuantity
     * @return \Sabre\BargainFinderMax\Structs\PTCFareBreakdownType
     */
    public function setPassengerTypeQuantity(\Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType $passengerTypeQuantity = null)
    {
        $this->PassengerTypeQuantity = $passengerTypeQuantity;
        return $this;
    }
    /**
     * Get FareBasisCodes value
     * @return \Sabre\BargainFinderMax\Structs\FareBasisCodes|null
     */
    public function getFareBasisCodes()
    {
        return $this->FareBasisCodes;
    }
    /**
     * Set FareBasisCodes value
     * @param \Sabre\BargainFinderMax\Structs\FareBasisCodes $fareBasisCodes
     * @return \Sabre\BargainFinderMax\Structs\PTCFareBreakdownType
     */
    public function setFareBasisCodes(\Sabre\BargainFinderMax\Structs\FareBasisCodes $fareBasisCodes = null)
    {
        $this->FareBasisCodes = $fareBasisCodes;
        return $this;
    }
    /**
     * Get PassengerFare value
     * @return \Sabre\BargainFinderMax\Structs\FareType|null
     */
    public function getPassengerFare()
    {
        return $this->PassengerFare;
    }
    /**
     * Set PassengerFare value
     * @param \Sabre\BargainFinderMax\Structs\FareType $passengerFare
     * @return \Sabre\BargainFinderMax\Structs\PTCFareBreakdownType
     */
    public function setPassengerFare(\Sabre\BargainFinderMax\Structs\FareType $passengerFare = null)
    {
        $this->PassengerFare = $passengerFare;
        return $this;
    }
    /**
     * Get Endorsements value
     * @return \Sabre\BargainFinderMax\Structs\Endorsements|null
     */
    public function getEndorsements()
    {
        return $this->Endorsements;
    }
    /**
     * Set Endorsements value
     * @param \Sabre\BargainFinderMax\Structs\Endorsements $endorsements
     * @return \Sabre\BargainFinderMax\Structs\PTCFareBreakdownType
     */
    public function setEndorsements(\Sabre\BargainFinderMax\Structs\Endorsements $endorsements = null)
    {
        $this->Endorsements = $endorsements;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \Sabre\BargainFinderMax\Structs\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\PTCFareBreakdownType
     */
    public function setTPA_Extensions(\Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get FareInfos value
     * @return \Sabre\BargainFinderMax\Structs\FareInfos|null
     */
    public function getFareInfos()
    {
        return $this->FareInfos;
    }
    /**
     * Set FareInfos value
     * @param \Sabre\BargainFinderMax\Structs\FareInfos $fareInfos
     * @return \Sabre\BargainFinderMax\Structs\PTCFareBreakdownType
     */
    public function setFareInfos(\Sabre\BargainFinderMax\Structs\FareInfos $fareInfos = null)
    {
        $this->FareInfos = $fareInfos;
        return $this;
    }
    /**
     * Get PricingSource value
     * @return string|null
     */
    public function getPricingSource()
    {
        return $this->PricingSource;
    }
    /**
     * Set PricingSource value
     * @param string $pricingSource
     * @return \Sabre\BargainFinderMax\Structs\PTCFareBreakdownType
     */
    public function setPricingSource($pricingSource = null)
    {
        $this->PricingSource = $pricingSource;
        return $this;
    }
    /**
     * Get PrivateFareType value
     * @return string|null
     */
    public function getPrivateFareType()
    {
        return $this->PrivateFareType;
    }
    /**
     * Set PrivateFareType value
     * @param string $privateFareType
     * @return \Sabre\BargainFinderMax\Structs\PTCFareBreakdownType
     */
    public function setPrivateFareType($privateFareType = null)
    {
        $this->PrivateFareType = $privateFareType;
        return $this;
    }
    /**
     * Get LastTicketDate value
     * @return string|null
     */
    public function getLastTicketDate()
    {
        return $this->LastTicketDate;
    }
    /**
     * Set LastTicketDate value
     * @param string $lastTicketDate
     * @return \Sabre\BargainFinderMax\Structs\PTCFareBreakdownType
     */
    public function setLastTicketDate($lastTicketDate = null)
    {
        $this->LastTicketDate = $lastTicketDate;
        return $this;
    }
    /**
     * Get PreviousExchangeDate value
     * @return string|null
     */
    public function getPreviousExchangeDate()
    {
        return $this->PreviousExchangeDate;
    }
    /**
     * Set PreviousExchangeDate value
     * @param string $previousExchangeDate
     * @return \Sabre\BargainFinderMax\Structs\PTCFareBreakdownType
     */
    public function setPreviousExchangeDate($previousExchangeDate = null)
    {
        $this->PreviousExchangeDate = $previousExchangeDate;
        return $this;
    }
    /**
     * Get ReissueExchange value
     * @return string|null
     */
    public function getReissueExchange()
    {
        return $this->ReissueExchange;
    }
    /**
     * Set ReissueExchange value
     * @param string $reissueExchange
     * @return \Sabre\BargainFinderMax\Structs\PTCFareBreakdownType
     */
    public function setReissueExchange($reissueExchange = null)
    {
        $this->ReissueExchange = $reissueExchange;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\PTCFareBreakdownType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
