<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationInformation Structs
 * Meta informations extracted from the WSDL
 * - documentation: Origin and Destination location, and time information for the Air Low Fare Search request.
 * - type: ExchangeOriginDestinationInformationType
 * @subpackage Structs
 */
class OriginDestinationInformation extends OriginDestinationInformationType
{
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: A placeholder for OriginDestinationInformation to be referenced wihin the OTA_AirLowFareSearchRS message. PricedItineraryType carries the reference to this RPH. | (Reference Place Holder) - an index code to identify an instance in a
     * collection of like items.. For example, used to assign individual passengers or clients to particular itinerary items.
     * - use: optional
     * - pattern: [0-9]{1,8}
     * @var string
     */
    public $RPH;
    /**
     * The Fixed
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: OriginDestination node with flight and fare information fixed. Used in context shopping
     * - use: optional
     * @var bool
     */
    public $Fixed;
    /**
     * The FullDiversity
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Request for full diversity of flights for the particular OriginDestination node. Used in Exchange Context Shopping
     * - use: optional
     * @var bool
     */
    public $FullDiversity;
    /**
     * Constructor method for OriginDestinationInformation
     * @uses OriginDestinationInformation::setTPA_Extensions()
     * @uses OriginDestinationInformation::setRPH()
     * @uses OriginDestinationInformation::setFixed()
     * @uses OriginDestinationInformation::setFullDiversity()
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @param string $rPH
     * @param bool $fixed
     * @param bool $fullDiversity
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null, $rPH = null, $fixed = false, $fullDiversity = false)
    {
        $this
            ->setTPA_Extensions($tPA_Extensions)
            ->setRPH($rPH)
            ->setFixed($fixed)
            ->setFullDiversity($fullDiversity);
    }
    /**
     * Get TPA_Extensions value
     * @return \Sabre\BargainFinderMax\Structs\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationInformation
     */
    public function setTPA_Extensions(\Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationInformation
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Fixed value
     * @return bool|null
     */
    public function getFixed()
    {
        return $this->Fixed;
    }
    /**
     * Set Fixed value
     * @param bool $fixed
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationInformation
     */
    public function setFixed($fixed = false)
    {
        $this->Fixed = $fixed;
        return $this;
    }
    /**
     * Get FullDiversity value
     * @return bool|null
     */
    public function getFullDiversity()
    {
        return $this->FullDiversity;
    }
    /**
     * Set FullDiversity value
     * @param bool $fullDiversity
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationInformation
     */
    public function setFullDiversity($fullDiversity = false)
    {
        $this->FullDiversity = $fullDiversity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
