<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationFlightType Structs
 * @subpackage Structs
 */
class OriginDestinationFlightType extends AbstractStructBase
{
    /**
     * The OriginLocation
     * @var \Sabre\BargainFinderMax\Structs\RequestLocationType
     */
    public $OriginLocation;
    /**
     * The DestinationLocation
     * @var \Sabre\BargainFinderMax\Structs\RequestLocationType
     */
    public $DestinationLocation;
    /**
     * The Airline
     * @var \Sabre\BargainFinderMax\Structs\AirlineType
     */
    public $Airline;
    /**
     * The SideTrip
     * @var \Sabre\BargainFinderMax\Structs\SideTripType
     */
    public $SideTrip;
    /**
     * The Reservation
     * @var \Sabre\BargainFinderMax\Structs\ReservationType
     */
    public $Reservation;
    /**
     * The MileageDisplay
     * @var \Sabre\BargainFinderMax\Structs\MileageDisplayType
     */
    public $MileageDisplay;
    /**
     * The BookingDateTime
     * Meta informations extracted from the WSDL
     * - documentation: IntelliSell DateTime type with optional seconds component (required format: YYYY-MM-DDTHH:MM or YYYY-MM-DDTHH:MM:SS)
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}(:[0-9]{2})?
     * @var string
     */
    public $BookingDateTime;
    /**
     * The Fare
     * @var \Sabre\BargainFinderMax\Structs\FareOptionalDetailsType
     */
    public $Fare;
    /**
     * The PlusUp
     * @var \Sabre\BargainFinderMax\Structs\PlusUpType
     */
    public $PlusUp;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - documentation: Flight number
     * @var int
     */
    public $Number;
    /**
     * The DepartureDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Departure date and time | IntelliSell DateTime type with optional seconds component (required format: YYYY-MM-DDTHH:MM or YYYY-MM-DDTHH:MM:SS)
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}(:[0-9]{2})?
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The ArrivalDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Arrival date and time | IntelliSell DateTime type with optional seconds component (required format: YYYY-MM-DDTHH:MM or YYYY-MM-DDTHH:MM:SS)
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}(:[0-9]{2})?
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The MarriageStatus
     * Meta informations extracted from the WSDL
     * - documentation: Marriage status
     * @var string
     */
    public $MarriageStatus;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Flown
     * Meta informations extracted from the WSDL
     * - documentation: Specify whether the flight is flown.
     * @var bool
     */
    public $Flown;
    /**
     * The ClassOfService
     * Meta informations extracted from the WSDL
     * - documentation: Class of service
     * - pattern: [A-Z]{1,2}
     * @var string
     */
    public $ClassOfService;
    /**
     * The Shopped
     * Meta informations extracted from the WSDL
     * - documentation: Specify whether the flight is shopped.
     * @var bool
     */
    public $Shopped;
    /**
     * Constructor method for OriginDestinationFlightType
     * @uses OriginDestinationFlightType::setOriginLocation()
     * @uses OriginDestinationFlightType::setDestinationLocation()
     * @uses OriginDestinationFlightType::setAirline()
     * @uses OriginDestinationFlightType::setSideTrip()
     * @uses OriginDestinationFlightType::setReservation()
     * @uses OriginDestinationFlightType::setMileageDisplay()
     * @uses OriginDestinationFlightType::setBookingDateTime()
     * @uses OriginDestinationFlightType::setFare()
     * @uses OriginDestinationFlightType::setPlusUp()
     * @uses OriginDestinationFlightType::setNumber()
     * @uses OriginDestinationFlightType::setDepartureDateTime()
     * @uses OriginDestinationFlightType::setArrivalDateTime()
     * @uses OriginDestinationFlightType::setMarriageStatus()
     * @uses OriginDestinationFlightType::setType()
     * @uses OriginDestinationFlightType::setFlown()
     * @uses OriginDestinationFlightType::setClassOfService()
     * @uses OriginDestinationFlightType::setShopped()
     * @param \Sabre\BargainFinderMax\Structs\RequestLocationType $originLocation
     * @param \Sabre\BargainFinderMax\Structs\RequestLocationType $destinationLocation
     * @param \Sabre\BargainFinderMax\Structs\AirlineType $airline
     * @param \Sabre\BargainFinderMax\Structs\SideTripType $sideTrip
     * @param \Sabre\BargainFinderMax\Structs\ReservationType $reservation
     * @param \Sabre\BargainFinderMax\Structs\MileageDisplayType $mileageDisplay
     * @param string $bookingDateTime
     * @param \Sabre\BargainFinderMax\Structs\FareOptionalDetailsType $fare
     * @param \Sabre\BargainFinderMax\Structs\PlusUpType $plusUp
     * @param int $number
     * @param string $departureDateTime
     * @param string $arrivalDateTime
     * @param string $marriageStatus
     * @param string $type
     * @param bool $flown
     * @param string $classOfService
     * @param bool $shopped
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\RequestLocationType $originLocation = null, \Sabre\BargainFinderMax\Structs\RequestLocationType $destinationLocation = null, \Sabre\BargainFinderMax\Structs\AirlineType $airline = null, \Sabre\BargainFinderMax\Structs\SideTripType $sideTrip = null, \Sabre\BargainFinderMax\Structs\ReservationType $reservation = null, \Sabre\BargainFinderMax\Structs\MileageDisplayType $mileageDisplay = null, $bookingDateTime = null, \Sabre\BargainFinderMax\Structs\FareOptionalDetailsType $fare = null, \Sabre\BargainFinderMax\Structs\PlusUpType $plusUp = null, $number = null, $departureDateTime = null, $arrivalDateTime = null, $marriageStatus = null, $type = null, $flown = null, $classOfService = null, $shopped = null)
    {
        $this
            ->setOriginLocation($originLocation)
            ->setDestinationLocation($destinationLocation)
            ->setAirline($airline)
            ->setSideTrip($sideTrip)
            ->setReservation($reservation)
            ->setMileageDisplay($mileageDisplay)
            ->setBookingDateTime($bookingDateTime)
            ->setFare($fare)
            ->setPlusUp($plusUp)
            ->setNumber($number)
            ->setDepartureDateTime($departureDateTime)
            ->setArrivalDateTime($arrivalDateTime)
            ->setMarriageStatus($marriageStatus)
            ->setType($type)
            ->setFlown($flown)
            ->setClassOfService($classOfService)
            ->setShopped($shopped);
    }
    /**
     * Get OriginLocation value
     * @return \Sabre\BargainFinderMax\Structs\RequestLocationType|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \Sabre\BargainFinderMax\Structs\RequestLocationType $originLocation
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationFlightType
     */
    public function setOriginLocation(\Sabre\BargainFinderMax\Structs\RequestLocationType $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return \Sabre\BargainFinderMax\Structs\RequestLocationType|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \Sabre\BargainFinderMax\Structs\RequestLocationType $destinationLocation
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationFlightType
     */
    public function setDestinationLocation(\Sabre\BargainFinderMax\Structs\RequestLocationType $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get Airline value
     * @return \Sabre\BargainFinderMax\Structs\AirlineType|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param \Sabre\BargainFinderMax\Structs\AirlineType $airline
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationFlightType
     */
    public function setAirline(\Sabre\BargainFinderMax\Structs\AirlineType $airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get SideTrip value
     * @return \Sabre\BargainFinderMax\Structs\SideTripType|null
     */
    public function getSideTrip()
    {
        return $this->SideTrip;
    }
    /**
     * Set SideTrip value
     * @param \Sabre\BargainFinderMax\Structs\SideTripType $sideTrip
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationFlightType
     */
    public function setSideTrip(\Sabre\BargainFinderMax\Structs\SideTripType $sideTrip = null)
    {
        $this->SideTrip = $sideTrip;
        return $this;
    }
    /**
     * Get Reservation value
     * @return \Sabre\BargainFinderMax\Structs\ReservationType|null
     */
    public function getReservation()
    {
        return $this->Reservation;
    }
    /**
     * Set Reservation value
     * @param \Sabre\BargainFinderMax\Structs\ReservationType $reservation
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationFlightType
     */
    public function setReservation(\Sabre\BargainFinderMax\Structs\ReservationType $reservation = null)
    {
        $this->Reservation = $reservation;
        return $this;
    }
    /**
     * Get MileageDisplay value
     * @return \Sabre\BargainFinderMax\Structs\MileageDisplayType|null
     */
    public function getMileageDisplay()
    {
        return $this->MileageDisplay;
    }
    /**
     * Set MileageDisplay value
     * @param \Sabre\BargainFinderMax\Structs\MileageDisplayType $mileageDisplay
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationFlightType
     */
    public function setMileageDisplay(\Sabre\BargainFinderMax\Structs\MileageDisplayType $mileageDisplay = null)
    {
        $this->MileageDisplay = $mileageDisplay;
        return $this;
    }
    /**
     * Get BookingDateTime value
     * @return string|null
     */
    public function getBookingDateTime()
    {
        return $this->BookingDateTime;
    }
    /**
     * Set BookingDateTime value
     * @param string $bookingDateTime
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationFlightType
     */
    public function setBookingDateTime($bookingDateTime = null)
    {
        $this->BookingDateTime = $bookingDateTime;
        return $this;
    }
    /**
     * Get Fare value
     * @return \Sabre\BargainFinderMax\Structs\FareOptionalDetailsType|null
     */
    public function getFare()
    {
        return $this->Fare;
    }
    /**
     * Set Fare value
     * @param \Sabre\BargainFinderMax\Structs\FareOptionalDetailsType $fare
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationFlightType
     */
    public function setFare(\Sabre\BargainFinderMax\Structs\FareOptionalDetailsType $fare = null)
    {
        $this->Fare = $fare;
        return $this;
    }
    /**
     * Get PlusUp value
     * @return \Sabre\BargainFinderMax\Structs\PlusUpType|null
     */
    public function getPlusUp()
    {
        return $this->PlusUp;
    }
    /**
     * Set PlusUp value
     * @param \Sabre\BargainFinderMax\Structs\PlusUpType $plusUp
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationFlightType
     */
    public function setPlusUp(\Sabre\BargainFinderMax\Structs\PlusUpType $plusUp = null)
    {
        $this->PlusUp = $plusUp;
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationFlightType
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationFlightType
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationFlightType
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get MarriageStatus value
     * @return string|null
     */
    public function getMarriageStatus()
    {
        return $this->MarriageStatus;
    }
    /**
     * Set MarriageStatus value
     * @param string $marriageStatus
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationFlightType
     */
    public function setMarriageStatus($marriageStatus = null)
    {
        $this->MarriageStatus = $marriageStatus;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationFlightType
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Flown value
     * @return bool|null
     */
    public function getFlown()
    {
        return $this->Flown;
    }
    /**
     * Set Flown value
     * @param bool $flown
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationFlightType
     */
    public function setFlown($flown = null)
    {
        $this->Flown = $flown;
        return $this;
    }
    /**
     * Get ClassOfService value
     * @return string|null
     */
    public function getClassOfService()
    {
        return $this->ClassOfService;
    }
    /**
     * Set ClassOfService value
     * @param string $classOfService
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationFlightType
     */
    public function setClassOfService($classOfService = null)
    {
        $this->ClassOfService = $classOfService;
        return $this;
    }
    /**
     * Get Shopped value
     * @return bool|null
     */
    public function getShopped()
    {
        return $this->Shopped;
    }
    /**
     * Set Shopped value
     * @param bool $shopped
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationFlightType
     */
    public function setShopped($shopped = null)
    {
        $this->Shopped = $shopped;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\OriginDestinationFlightType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
