<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ops Structs
 * Meta informations extracted from the WSDL
 * - documentation: Populated if an Ops rule has been hit.
 * @subpackage Structs
 */
class Ops extends AbstractStructBase
{
    /**
     * The ActionCode
     * Meta informations extracted from the WSDL
     * - documentation: Corresponds to data in the Ops rule (action target: Ops Action). The numeric id corresponds to an action performed by Travelocity.
     * - use: required
     * @var int
     */
    public $ActionCode;
    /**
     * The FareTypes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\FareTypes
     */
    public $FareTypes;
    /**
     * Constructor method for Ops
     * @uses Ops::setActionCode()
     * @uses Ops::setFareTypes()
     * @param int $actionCode
     * @param \Sabre\BargainFinderMax\Structs\FareTypes $fareTypes
     */
    public function __construct($actionCode = null, \Sabre\BargainFinderMax\Structs\FareTypes $fareTypes = null)
    {
        $this
            ->setActionCode($actionCode)
            ->setFareTypes($fareTypes);
    }
    /**
     * Get ActionCode value
     * @return int
     */
    public function getActionCode()
    {
        return $this->ActionCode;
    }
    /**
     * Set ActionCode value
     * @param int $actionCode
     * @return \Sabre\BargainFinderMax\Structs\Ops
     */
    public function setActionCode($actionCode = null)
    {
        $this->ActionCode = $actionCode;
        return $this;
    }
    /**
     * Get FareTypes value
     * @return \Sabre\BargainFinderMax\Structs\FareTypes|null
     */
    public function getFareTypes()
    {
        return $this->FareTypes;
    }
    /**
     * Set FareTypes value
     * @param \Sabre\BargainFinderMax\Structs\FareTypes $fareTypes
     * @return \Sabre\BargainFinderMax\Structs\Ops
     */
    public function setFareTypes(\Sabre\BargainFinderMax\Structs\FareTypes $fareTypes = null)
    {
        $this->FareTypes = $fareTypes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Ops
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
