<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_AirLowFareSearchRS Structs
 * Meta informations extracted from the WSDL
 * - documentation: The Low Fare Search Response message contains a number of .Priced Itinerary. options. Each includes: - A set of available flights matching the client.s request. - Pricing information including taxes and full fare breakdown for each
 * passenger type - Ticketing information - Fare Basis Codes and the information necessary to make a rules entry. This message contains similar information to a standard airline CRS or GDS Low Fare Search Response message.
 * @subpackage Structs
 */
class OTA_AirLowFareSearchRS extends AbstractStructBase
{
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - documentation: In case of failure errors are returned.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ErrorsType
     */
    public $Errors;
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - documentation: In case of success this element is returned.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\SuccessType
     */
    public $Success;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - documentation: In case of any warnings this element is returned.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\WarningsType
     */
    public $Warnings;
    /**
     * The BrandFeatures
     * Meta informations extracted from the WSDL
     * - documentation: Final list of all brand feature items
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\BrandFeatureListType
     */
    public $BrandFeatures;
    /**
     * The PricedItineraries
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\PricedItineraries
     */
    public $PricedItineraries;
    /**
     * The OneWayItineraries
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\OneWayItineraries
     */
    public $OneWayItineraries;
    /**
     * The DepartedItineraries
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\DepartedItineraries
     */
    public $DepartedItineraries;
    /**
     * The SoldOutItineraries
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\SoldOutItineraries
     */
    public $SoldOutItineraries;
    /**
     * The AvailableItineraries
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AvailableItineraries
     */
    public $AvailableItineraries;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The PricedItinCount
     * Meta informations extracted from the WSDL
     * - documentation: Itinerary count for Priced Round-Trip itineraries
     * - use: optional
     * @var int
     */
    public $PricedItinCount;
    /**
     * The BrandedOneWayItinCount
     * Meta informations extracted from the WSDL
     * - documentation: Itinerary count for Branded One-Way itineraries
     * - use: optional
     * @var int
     */
    public $BrandedOneWayItinCount;
    /**
     * The SimpleOneWayItinCount
     * Meta informations extracted from the WSDL
     * - documentation: Itinerary count for Simple One-Way itineraries
     * - use: optional
     * @var int
     */
    public $SimpleOneWayItinCount;
    /**
     * The DepartedItinCount
     * Meta informations extracted from the WSDL
     * - documentation: Itinerary count for departed itineraries returned
     * - use: optional
     * @var int
     */
    public $DepartedItinCount;
    /**
     * The SoldOutItinCount
     * Meta informations extracted from the WSDL
     * - documentation: Itinerary count for sold out itineraries returned
     * - use: optional
     * @var int
     */
    public $SoldOutItinCount;
    /**
     * The AvailableItinCount
     * Meta informations extracted from the WSDL
     * - documentation: Itinerary count for available itineraries returned
     * - use: optional
     * @var int
     */
    public $AvailableItinCount;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * Meta informations extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * Meta informations extracted from the WSDL
     * - union: positiveInteger | boolean
     * @var string
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The PrimaryLangID
     * @var string
     */
    public $PrimaryLangID;
    /**
     * The AltLangID
     * @var string
     */
    public $AltLangID;
    /**
     * Constructor method for OTA_AirLowFareSearchRS
     * @uses OTA_AirLowFareSearchRS::setErrors()
     * @uses OTA_AirLowFareSearchRS::setSuccess()
     * @uses OTA_AirLowFareSearchRS::setWarnings()
     * @uses OTA_AirLowFareSearchRS::setBrandFeatures()
     * @uses OTA_AirLowFareSearchRS::setPricedItineraries()
     * @uses OTA_AirLowFareSearchRS::setOneWayItineraries()
     * @uses OTA_AirLowFareSearchRS::setDepartedItineraries()
     * @uses OTA_AirLowFareSearchRS::setSoldOutItineraries()
     * @uses OTA_AirLowFareSearchRS::setAvailableItineraries()
     * @uses OTA_AirLowFareSearchRS::setTPA_Extensions()
     * @uses OTA_AirLowFareSearchRS::setPricedItinCount()
     * @uses OTA_AirLowFareSearchRS::setBrandedOneWayItinCount()
     * @uses OTA_AirLowFareSearchRS::setSimpleOneWayItinCount()
     * @uses OTA_AirLowFareSearchRS::setDepartedItinCount()
     * @uses OTA_AirLowFareSearchRS::setSoldOutItinCount()
     * @uses OTA_AirLowFareSearchRS::setAvailableItinCount()
     * @uses OTA_AirLowFareSearchRS::setEchoToken()
     * @uses OTA_AirLowFareSearchRS::setTimeStamp()
     * @uses OTA_AirLowFareSearchRS::setTarget()
     * @uses OTA_AirLowFareSearchRS::setVersion()
     * @uses OTA_AirLowFareSearchRS::setTransactionIdentifier()
     * @uses OTA_AirLowFareSearchRS::setSequenceNmbr()
     * @uses OTA_AirLowFareSearchRS::setTransactionStatusCode()
     * @uses OTA_AirLowFareSearchRS::setPrimaryLangID()
     * @uses OTA_AirLowFareSearchRS::setAltLangID()
     * @param \Sabre\BargainFinderMax\Structs\ErrorsType $errors
     * @param \Sabre\BargainFinderMax\Structs\SuccessType $success
     * @param \Sabre\BargainFinderMax\Structs\WarningsType $warnings
     * @param \Sabre\BargainFinderMax\Structs\BrandFeatureListType $brandFeatures
     * @param \Sabre\BargainFinderMax\Structs\PricedItineraries $pricedItineraries
     * @param \Sabre\BargainFinderMax\Structs\OneWayItineraries $oneWayItineraries
     * @param \Sabre\BargainFinderMax\Structs\DepartedItineraries $departedItineraries
     * @param \Sabre\BargainFinderMax\Structs\SoldOutItineraries $soldOutItineraries
     * @param \Sabre\BargainFinderMax\Structs\AvailableItineraries $availableItineraries
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @param int $pricedItinCount
     * @param int $brandedOneWayItinCount
     * @param int $simpleOneWayItinCount
     * @param int $departedItinCount
     * @param int $soldOutItinCount
     * @param int $availableItinCount
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $version
     * @param string $transactionIdentifier
     * @param string $sequenceNmbr
     * @param string $transactionStatusCode
     * @param string $primaryLangID
     * @param string $altLangID
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\ErrorsType $errors = null, \Sabre\BargainFinderMax\Structs\SuccessType $success = null, \Sabre\BargainFinderMax\Structs\WarningsType $warnings = null, \Sabre\BargainFinderMax\Structs\BrandFeatureListType $brandFeatures = null, \Sabre\BargainFinderMax\Structs\PricedItineraries $pricedItineraries = null, \Sabre\BargainFinderMax\Structs\OneWayItineraries $oneWayItineraries = null, \Sabre\BargainFinderMax\Structs\DepartedItineraries $departedItineraries = null, \Sabre\BargainFinderMax\Structs\SoldOutItineraries $soldOutItineraries = null, \Sabre\BargainFinderMax\Structs\AvailableItineraries $availableItineraries = null, \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null, $pricedItinCount = null, $brandedOneWayItinCount = null, $simpleOneWayItinCount = null, $departedItinCount = null, $soldOutItinCount = null, $availableItinCount = null, $echoToken = null, $timeStamp = null, $target = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $primaryLangID = null, $altLangID = null)
    {
        $this
            ->setErrors($errors)
            ->setSuccess($success)
            ->setWarnings($warnings)
            ->setBrandFeatures($brandFeatures)
            ->setPricedItineraries($pricedItineraries)
            ->setOneWayItineraries($oneWayItineraries)
            ->setDepartedItineraries($departedItineraries)
            ->setSoldOutItineraries($soldOutItineraries)
            ->setAvailableItineraries($availableItineraries)
            ->setTPA_Extensions($tPA_Extensions)
            ->setPricedItinCount($pricedItinCount)
            ->setBrandedOneWayItinCount($brandedOneWayItinCount)
            ->setSimpleOneWayItinCount($simpleOneWayItinCount)
            ->setDepartedItinCount($departedItinCount)
            ->setSoldOutItinCount($soldOutItinCount)
            ->setAvailableItinCount($availableItinCount)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setPrimaryLangID($primaryLangID)
            ->setAltLangID($altLangID);
    }
    /**
     * Get Errors value
     * @return \Sabre\BargainFinderMax\Structs\ErrorsType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \Sabre\BargainFinderMax\Structs\ErrorsType $errors
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setErrors(\Sabre\BargainFinderMax\Structs\ErrorsType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Success value
     * @return \Sabre\BargainFinderMax\Structs\SuccessType|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param \Sabre\BargainFinderMax\Structs\SuccessType $success
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setSuccess(\Sabre\BargainFinderMax\Structs\SuccessType $success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \Sabre\BargainFinderMax\Structs\WarningsType|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \Sabre\BargainFinderMax\Structs\WarningsType $warnings
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setWarnings(\Sabre\BargainFinderMax\Structs\WarningsType $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get BrandFeatures value
     * @return \Sabre\BargainFinderMax\Structs\BrandFeatureListType|null
     */
    public function getBrandFeatures()
    {
        return $this->BrandFeatures;
    }
    /**
     * Set BrandFeatures value
     * @param \Sabre\BargainFinderMax\Structs\BrandFeatureListType $brandFeatures
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setBrandFeatures(\Sabre\BargainFinderMax\Structs\BrandFeatureListType $brandFeatures = null)
    {
        $this->BrandFeatures = $brandFeatures;
        return $this;
    }
    /**
     * Get PricedItineraries value
     * @return \Sabre\BargainFinderMax\Structs\PricedItineraries|null
     */
    public function getPricedItineraries()
    {
        return $this->PricedItineraries;
    }
    /**
     * Set PricedItineraries value
     * @param \Sabre\BargainFinderMax\Structs\PricedItineraries $pricedItineraries
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setPricedItineraries(\Sabre\BargainFinderMax\Structs\PricedItineraries $pricedItineraries = null)
    {
        $this->PricedItineraries = $pricedItineraries;
        return $this;
    }
    /**
     * Get OneWayItineraries value
     * @return \Sabre\BargainFinderMax\Structs\OneWayItineraries|null
     */
    public function getOneWayItineraries()
    {
        return $this->OneWayItineraries;
    }
    /**
     * Set OneWayItineraries value
     * @param \Sabre\BargainFinderMax\Structs\OneWayItineraries $oneWayItineraries
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setOneWayItineraries(\Sabre\BargainFinderMax\Structs\OneWayItineraries $oneWayItineraries = null)
    {
        $this->OneWayItineraries = $oneWayItineraries;
        return $this;
    }
    /**
     * Get DepartedItineraries value
     * @return \Sabre\BargainFinderMax\Structs\DepartedItineraries|null
     */
    public function getDepartedItineraries()
    {
        return $this->DepartedItineraries;
    }
    /**
     * Set DepartedItineraries value
     * @param \Sabre\BargainFinderMax\Structs\DepartedItineraries $departedItineraries
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setDepartedItineraries(\Sabre\BargainFinderMax\Structs\DepartedItineraries $departedItineraries = null)
    {
        $this->DepartedItineraries = $departedItineraries;
        return $this;
    }
    /**
     * Get SoldOutItineraries value
     * @return \Sabre\BargainFinderMax\Structs\SoldOutItineraries|null
     */
    public function getSoldOutItineraries()
    {
        return $this->SoldOutItineraries;
    }
    /**
     * Set SoldOutItineraries value
     * @param \Sabre\BargainFinderMax\Structs\SoldOutItineraries $soldOutItineraries
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setSoldOutItineraries(\Sabre\BargainFinderMax\Structs\SoldOutItineraries $soldOutItineraries = null)
    {
        $this->SoldOutItineraries = $soldOutItineraries;
        return $this;
    }
    /**
     * Get AvailableItineraries value
     * @return \Sabre\BargainFinderMax\Structs\AvailableItineraries|null
     */
    public function getAvailableItineraries()
    {
        return $this->AvailableItineraries;
    }
    /**
     * Set AvailableItineraries value
     * @param \Sabre\BargainFinderMax\Structs\AvailableItineraries $availableItineraries
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setAvailableItineraries(\Sabre\BargainFinderMax\Structs\AvailableItineraries $availableItineraries = null)
    {
        $this->AvailableItineraries = $availableItineraries;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \Sabre\BargainFinderMax\Structs\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setTPA_Extensions(\Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get PricedItinCount value
     * @return int|null
     */
    public function getPricedItinCount()
    {
        return $this->PricedItinCount;
    }
    /**
     * Set PricedItinCount value
     * @param int $pricedItinCount
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setPricedItinCount($pricedItinCount = null)
    {
        $this->PricedItinCount = $pricedItinCount;
        return $this;
    }
    /**
     * Get BrandedOneWayItinCount value
     * @return int|null
     */
    public function getBrandedOneWayItinCount()
    {
        return $this->BrandedOneWayItinCount;
    }
    /**
     * Set BrandedOneWayItinCount value
     * @param int $brandedOneWayItinCount
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setBrandedOneWayItinCount($brandedOneWayItinCount = null)
    {
        $this->BrandedOneWayItinCount = $brandedOneWayItinCount;
        return $this;
    }
    /**
     * Get SimpleOneWayItinCount value
     * @return int|null
     */
    public function getSimpleOneWayItinCount()
    {
        return $this->SimpleOneWayItinCount;
    }
    /**
     * Set SimpleOneWayItinCount value
     * @param int $simpleOneWayItinCount
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setSimpleOneWayItinCount($simpleOneWayItinCount = null)
    {
        $this->SimpleOneWayItinCount = $simpleOneWayItinCount;
        return $this;
    }
    /**
     * Get DepartedItinCount value
     * @return int|null
     */
    public function getDepartedItinCount()
    {
        return $this->DepartedItinCount;
    }
    /**
     * Set DepartedItinCount value
     * @param int $departedItinCount
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setDepartedItinCount($departedItinCount = null)
    {
        $this->DepartedItinCount = $departedItinCount;
        return $this;
    }
    /**
     * Get SoldOutItinCount value
     * @return int|null
     */
    public function getSoldOutItinCount()
    {
        return $this->SoldOutItinCount;
    }
    /**
     * Set SoldOutItinCount value
     * @param int $soldOutItinCount
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setSoldOutItinCount($soldOutItinCount = null)
    {
        $this->SoldOutItinCount = $soldOutItinCount;
        return $this;
    }
    /**
     * Get AvailableItinCount value
     * @return int|null
     */
    public function getAvailableItinCount()
    {
        return $this->AvailableItinCount;
    }
    /**
     * Set AvailableItinCount value
     * @param int $availableItinCount
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setAvailableItinCount($availableItinCount = null)
    {
        $this->AvailableItinCount = $availableItinCount;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setEchoToken($echoToken = null)
    {
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setTarget($target = null)
    {
        $this->Target = $target;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return string|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param string $sequenceNmbr
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get PrimaryLangID value
     * @return string|null
     */
    public function getPrimaryLangID()
    {
        return $this->PrimaryLangID;
    }
    /**
     * Set PrimaryLangID value
     * @param string $primaryLangID
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setPrimaryLangID($primaryLangID = null)
    {
        $this->PrimaryLangID = $primaryLangID;
        return $this;
    }
    /**
     * Get AltLangID value
     * @return string|null
     */
    public function getAltLangID()
    {
        return $this->AltLangID;
    }
    /**
     * Set AltLangID value
     * @param string $altLangID
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public function setAltLangID($altLangID = null)
    {
        $this->AltLangID = $altLangID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\OTA_AirLowFareSearchRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
