<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OBFees Structs
 * Meta informations extracted from the WSDL
 * - documentation: This is a collection of ob Fees
 * @subpackage Structs
 */
class OBFees extends AbstractStructBase
{
    /**
     * The RType
     * Meta informations extracted from the WSDL
     * - documentation: Indicator Returning R-Type OB Fees
     * @var bool
     */
    public $RType;
    /**
     * The TType
     * Meta informations extracted from the WSDL
     * - documentation: Indicator Returning T-Type OB Fees
     * @var bool
     */
    public $TType;
    /**
     * The OBFee
     * Meta informations extracted from the WSDL
     * - documentation: OB fees
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\OBFeeType[]
     */
    public $OBFee;
    /**
     * The TTypeAmount
     * Meta informations extracted from the WSDL
     * - documentation: Total T-type OB Fee | Used for amounts, max 3 decimals
     * - use: optional
     * - fractionDigits: 3
     * @var float
     */
    public $TTypeAmount;
    /**
     * Constructor method for OBFees
     * @uses OBFees::setRType()
     * @uses OBFees::setTType()
     * @uses OBFees::setOBFee()
     * @uses OBFees::setTTypeAmount()
     * @param bool $rType
     * @param bool $tType
     * @param \Sabre\BargainFinderMax\Structs\OBFeeType[] $oBFee
     * @param float $tTypeAmount
     */
    public function __construct($rType = null, $tType = null, array $oBFee = array(), $tTypeAmount = null)
    {
        $this
            ->setRType($rType)
            ->setTType($tType)
            ->setOBFee($oBFee)
            ->setTTypeAmount($tTypeAmount);
    }
    /**
     * Get RType value
     * @return bool|null
     */
    public function getRType()
    {
        return $this->RType;
    }
    /**
     * Set RType value
     * @param bool $rType
     * @return \Sabre\BargainFinderMax\Structs\OBFees
     */
    public function setRType($rType = null)
    {
        $this->RType = $rType;
        return $this;
    }
    /**
     * Get TType value
     * @return bool|null
     */
    public function getTType()
    {
        return $this->TType;
    }
    /**
     * Set TType value
     * @param bool $tType
     * @return \Sabre\BargainFinderMax\Structs\OBFees
     */
    public function setTType($tType = null)
    {
        $this->TType = $tType;
        return $this;
    }
    /**
     * Get OBFee value
     * @return \Sabre\BargainFinderMax\Structs\OBFeeType[]|null
     */
    public function getOBFee()
    {
        return $this->OBFee;
    }
    /**
     * Set OBFee value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\OBFeeType[] $oBFee
     * @return \Sabre\BargainFinderMax\Structs\OBFees
     */
    public function setOBFee(array $oBFee = array())
    {
        $this->OBFee = $oBFee;
        return $this;
    }
    /**
     * Add item to OBFee value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\OBFeeType $item
     * @return \Sabre\BargainFinderMax\Structs\OBFees
     */
    public function addToOBFee(\Sabre\BargainFinderMax\Structs\OBFeeType $item)
    {
        $this->OBFee[] = $item;
        return $this;
    }
    /**
     * Get TTypeAmount value
     * @return float|null
     */
    public function getTTypeAmount()
    {
        return $this->TTypeAmount;
    }
    /**
     * Set TTypeAmount value
     * @param float $tTypeAmount
     * @return \Sabre\BargainFinderMax\Structs\OBFees
     */
    public function setTTypeAmount($tTypeAmount = null)
    {
        $this->TTypeAmount = $tTypeAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\OBFees
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
