<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MileageDisplayType Structs
 * @subpackage Structs
 */
class MileageDisplayType extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: Mileage display type
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - documentation: Mileage display city | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - use: optional
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $City;
    /**
     * The Surcharge
     * Meta informations extracted from the WSDL
     * - documentation: Mileage surcharge percentage
     * - use: optional
     * @var int
     */
    public $Surcharge;
    /**
     * Constructor method for MileageDisplayType
     * @uses MileageDisplayType::setType()
     * @uses MileageDisplayType::setCity()
     * @uses MileageDisplayType::setSurcharge()
     * @param string $type
     * @param string $city
     * @param int $surcharge
     */
    public function __construct($type = null, $city = null, $surcharge = null)
    {
        $this
            ->setType($type)
            ->setCity($city)
            ->setSurcharge($surcharge);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\BargainFinderMax\Structs\MileageDisplayType
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \Sabre\BargainFinderMax\Structs\MileageDisplayType
     */
    public function setCity($city = null)
    {
        $this->City = $city;
        return $this;
    }
    /**
     * Get Surcharge value
     * @return int|null
     */
    public function getSurcharge()
    {
        return $this->Surcharge;
    }
    /**
     * Set Surcharge value
     * @param int $surcharge
     * @return \Sabre\BargainFinderMax\Structs\MileageDisplayType
     */
    public function setSurcharge($surcharge = null)
    {
        $this->Surcharge = $surcharge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\MileageDisplayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
