<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LegsTaxes Structs
 * @subpackage Structs
 */
class LegsTaxes extends AbstractStructBase
{
    /**
     * The LegTaxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * @var \Sabre\BargainFinderMax\Structs\LegTaxes[]
     */
    public $LegTaxes;
    /**
     * Constructor method for LegsTaxes
     * @uses LegsTaxes::setLegTaxes()
     * @param \Sabre\BargainFinderMax\Structs\LegTaxes[] $legTaxes
     */
    public function __construct(array $legTaxes = array())
    {
        $this
            ->setLegTaxes($legTaxes);
    }
    /**
     * Get LegTaxes value
     * @return \Sabre\BargainFinderMax\Structs\LegTaxes[]|null
     */
    public function getLegTaxes()
    {
        return $this->LegTaxes;
    }
    /**
     * Set LegTaxes value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\LegTaxes[] $legTaxes
     * @return \Sabre\BargainFinderMax\Structs\LegsTaxes
     */
    public function setLegTaxes(array $legTaxes = array())
    {
        $this->LegTaxes = $legTaxes;
        return $this;
    }
    /**
     * Add item to LegTaxes value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\LegTaxes $item
     * @return \Sabre\BargainFinderMax\Structs\LegsTaxes
     */
    public function addToLegTaxes(\Sabre\BargainFinderMax\Structs\LegTaxes $item)
    {
        $this->LegTaxes[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\LegsTaxes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
