<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Legs Structs
 * Meta informations extracted from the WSDL
 * - documentation: This is a collection of Leg Information | This is a collection of Leg Information
 * @subpackage Structs
 */
class Legs extends AbstractStructBase
{
    /**
     * The Leg
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\BargainFinderMax\Structs\Leg[]
     */
    public $Leg;
    /**
     * Constructor method for Legs
     * @uses Legs::setLeg()
     * @param \Sabre\BargainFinderMax\Structs\Leg[] $leg
     */
    public function __construct(array $leg = array())
    {
        $this
            ->setLeg($leg);
    }
    /**
     * Get Leg value
     * @return \Sabre\BargainFinderMax\Structs\Leg[]|null
     */
    public function getLeg()
    {
        return $this->Leg;
    }
    /**
     * Set Leg value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Leg[] $leg
     * @return \Sabre\BargainFinderMax\Structs\Legs
     */
    public function setLeg(array $leg = array())
    {
        $this->Leg = $leg;
        return $this;
    }
    /**
     * Add item to Leg value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Leg $item
     * @return \Sabre\BargainFinderMax\Structs\Legs
     */
    public function addToLeg(\Sabre\BargainFinderMax\Structs\Leg $item)
    {
        $this->Leg[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Legs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
