<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LegTaxes Structs
 * @subpackage Structs
 */
class LegTaxes extends AbstractStructBase
{
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - documentation: Any individual tax applied to the fare
     * - maxOccurs: 99
     * @var \Sabre\BargainFinderMax\Structs\AirTaxType[]
     */
    public $Tax;
    /**
     * The TaxSummary
     * Meta informations extracted from the WSDL
     * - documentation: Tax Summary Information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AirTaxSummaryType[]
     */
    public $TaxSummary;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Number;
    /**
     * Constructor method for LegTaxes
     * @uses LegTaxes::setTax()
     * @uses LegTaxes::setTaxSummary()
     * @uses LegTaxes::setNumber()
     * @param \Sabre\BargainFinderMax\Structs\AirTaxType[] $tax
     * @param \Sabre\BargainFinderMax\Structs\AirTaxSummaryType[] $taxSummary
     * @param int $number
     */
    public function __construct(array $tax = array(), array $taxSummary = array(), $number = null)
    {
        $this
            ->setTax($tax)
            ->setTaxSummary($taxSummary)
            ->setNumber($number);
    }
    /**
     * Get Tax value
     * @return \Sabre\BargainFinderMax\Structs\AirTaxType[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AirTaxType[] $tax
     * @return \Sabre\BargainFinderMax\Structs\LegTaxes
     */
    public function setTax(array $tax = array())
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AirTaxType $item
     * @return \Sabre\BargainFinderMax\Structs\LegTaxes
     */
    public function addToTax(\Sabre\BargainFinderMax\Structs\AirTaxType $item)
    {
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get TaxSummary value
     * @return \Sabre\BargainFinderMax\Structs\AirTaxSummaryType[]|null
     */
    public function getTaxSummary()
    {
        return $this->TaxSummary;
    }
    /**
     * Set TaxSummary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AirTaxSummaryType[] $taxSummary
     * @return \Sabre\BargainFinderMax\Structs\LegTaxes
     */
    public function setTaxSummary(array $taxSummary = array())
    {
        $this->TaxSummary = $taxSummary;
        return $this;
    }
    /**
     * Add item to TaxSummary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AirTaxSummaryType $item
     * @return \Sabre\BargainFinderMax\Structs\LegTaxes
     */
    public function addToTaxSummary(\Sabre\BargainFinderMax\Structs\AirTaxSummaryType $item)
    {
        $this->TaxSummary[] = $item;
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \Sabre\BargainFinderMax\Structs\LegTaxes
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\LegTaxes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
