<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LegIDType Structs
 * @subpackage Structs
 */
class LegIDType extends AbstractStructBase
{
    /**
     * The Ref
     * Meta informations extracted from the WSDL
     * - documentation: Reference to LegDescription ID
     * - use: required
     * @var int
     */
    public $Ref;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - documentation: Departure date
     * - use: optional
     * @var string
     */
    public $DepartureDate;
    /**
     * Constructor method for LegIDType
     * @uses LegIDType::setRef()
     * @uses LegIDType::setDepartureDate()
     * @param int $ref
     * @param string $departureDate
     */
    public function __construct($ref = null, $departureDate = null)
    {
        $this
            ->setRef($ref)
            ->setDepartureDate($departureDate);
    }
    /**
     * Get Ref value
     * @return int
     */
    public function getRef()
    {
        return $this->Ref;
    }
    /**
     * Set Ref value
     * @param int $ref
     * @return \Sabre\BargainFinderMax\Structs\LegIDType
     */
    public function setRef($ref = null)
    {
        $this->Ref = $ref;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \Sabre\BargainFinderMax\Structs\LegIDType
     */
    public function setDepartureDate($departureDate = null)
    {
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\LegIDType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
