<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LegDescriptionType Structs
 * @subpackage Structs
 */
class LegDescriptionType extends AbstractStructBase
{
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - documentation: Departure date
     * - use: required
     * @var string
     */
    public $DepartureDate;
    /**
     * The DepartureLocation
     * Meta informations extracted from the WSDL
     * - documentation: Departure location code | Airport code type
     * - length: 3
     * - pattern: [A-Z]{3}
     * - type: UpperCaseAlphaNumericLength3to5
     * - use: optional
     * @var string
     */
    public $DepartureLocation;
    /**
     * The ArrivalLocation
     * Meta informations extracted from the WSDL
     * - documentation: Arrival location code | Airport code type
     * - length: 3
     * - pattern: [A-Z]{3}
     * - type: UpperCaseAlphaNumericLength3to5
     * - use: optional
     * @var string
     */
    public $ArrivalLocation;
    /**
     * Constructor method for LegDescriptionType
     * @uses LegDescriptionType::setDepartureDate()
     * @uses LegDescriptionType::setDepartureLocation()
     * @uses LegDescriptionType::setArrivalLocation()
     * @param string $departureDate
     * @param string $departureLocation
     * @param string $arrivalLocation
     */
    public function __construct($departureDate = null, $departureLocation = null, $arrivalLocation = null)
    {
        $this
            ->setDepartureDate($departureDate)
            ->setDepartureLocation($departureLocation)
            ->setArrivalLocation($arrivalLocation);
    }
    /**
     * Get DepartureDate value
     * @return string
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \Sabre\BargainFinderMax\Structs\LegDescriptionType
     */
    public function setDepartureDate($departureDate = null)
    {
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get DepartureLocation value
     * @return string|null
     */
    public function getDepartureLocation()
    {
        return $this->DepartureLocation;
    }
    /**
     * Set DepartureLocation value
     * @param string $departureLocation
     * @return \Sabre\BargainFinderMax\Structs\LegDescriptionType
     */
    public function setDepartureLocation($departureLocation = null)
    {
        $this->DepartureLocation = $departureLocation;
        return $this;
    }
    /**
     * Get ArrivalLocation value
     * @return string|null
     */
    public function getArrivalLocation()
    {
        return $this->ArrivalLocation;
    }
    /**
     * Set ArrivalLocation value
     * @param string $arrivalLocation
     * @return \Sabre\BargainFinderMax\Structs\LegDescriptionType
     */
    public function setArrivalLocation($arrivalLocation = null)
    {
        $this->ArrivalLocation = $arrivalLocation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\LegDescriptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
