<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Leg Structs
 * Meta informations extracted from the WSDL
 * - documentation: Single leg specification | Optional list of departure dates for each leg | Leg Information
 * @subpackage Structs
 */
class Leg extends AbstractStructBase
{
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: A placeholder for OriginDestinationInformation to be referenced wihin the OTA_AirLowFareSearchRS message. PricedItineraryType carries the reference to this RPH. | (Reference Place Holder) - an index code to identify an instance in a
     * collection of like items.. For example, used to assign individual passengers or clients to particular itinerary items.
     * - use: required
     * - pattern: [0-9]{1,8}
     * @var string
     */
    public $RPH;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - documentation: Departure date
     * - use: required
     * @var string
     */
    public $DepartureDate;
    /**
     * The DepartureDateTime
     * @var \Sabre\BargainFinderMax\Structs\DepartureDateTime
     */
    public $DepartureDateTime;
    /**
     * The ArrivalDateTime
     * @var \Sabre\BargainFinderMax\Structs\GlobalDateTimeType
     */
    public $ArrivalDateTime;
    /**
     * The Origins
     * @var \Sabre\BargainFinderMax\Structs\Origins
     */
    public $Origins;
    /**
     * The Destinations
     * @var \Sabre\BargainFinderMax\Structs\Destinations
     */
    public $Destinations;
    /**
     * The ConnectionLocations
     * Meta informations extracted from the WSDL
     * - documentation: Travel Connection Location - for example, air uses the IATA 3 letter code.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ConnectionType
     */
    public $ConnectionLocations;
    /**
     * The Carriers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Carriers
     */
    public $Carriers;
    /**
     * The Cabin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Cabin
     */
    public $Cabin;
    /**
     * The MaxOptions
     * Meta informations extracted from the WSDL
     * - documentation: Maximum number of options to return.
     * @var int
     */
    public $MaxOptions;
    /**
     * The Segment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Segment[]
     */
    public $Segment;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Number;
    /**
     * The BrandID
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BrandID;
    /**
     * The BrandDescription
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BrandDescription;
    /**
     * The ProgramName
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ProgramName;
    /**
     * The ProgramID
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ProgramID;
    /**
     * The ProgramCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ProgramCode;
    /**
     * The ProgramSystemCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ProgramSystemCode;
    /**
     * The FareStatus
     * Meta informations extracted from the WSDL
     * - documentation: Detailed reason why fare could not be returned (when FareReturned="false"). "A" means "Class is not available", "O" - "Class is not offered", "F" - "No fare found or applicable", "N" - unknown status. | Detailed reason why fare could
     * not be returned (when FareReturned="false"). "A" means "Class is not available", "O" - "Class is not offered", "F" - "No fare found or applicable", "N" - unknown status.
     * - use: optional
     * @var string
     */
    public $FareStatus;
    /**
     * The BaseFare
     * Meta informations extracted from the WSDL
     * - documentation: Price of the inventory excluding taxes and fees.
     * @var \Sabre\BargainFinderMax\Structs\CurrencyAmountType
     */
    public $BaseFare;
    /**
     * The EquivFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\EquivFare
     */
    public $EquivFare;
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Taxes
     */
    public $Taxes;
    /**
     * The TotalFare
     * Meta informations extracted from the WSDL
     * - documentation: The total price that the passenger would pay (includes fare, taxes, fees)
     * @var \Sabre\BargainFinderMax\Structs\CurrencyAmountType
     */
    public $TotalFare;
    /**
     * The TotalMileage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TotalMileage
     */
    public $TotalMileage;
    /**
     * Constructor method for Leg
     * @uses Leg::setRPH()
     * @uses Leg::setDepartureDate()
     * @uses Leg::setDepartureDateTime()
     * @uses Leg::setArrivalDateTime()
     * @uses Leg::setOrigins()
     * @uses Leg::setDestinations()
     * @uses Leg::setConnectionLocations()
     * @uses Leg::setCarriers()
     * @uses Leg::setCabin()
     * @uses Leg::setMaxOptions()
     * @uses Leg::setSegment()
     * @uses Leg::setNumber()
     * @uses Leg::setBrandID()
     * @uses Leg::setBrandDescription()
     * @uses Leg::setProgramName()
     * @uses Leg::setProgramID()
     * @uses Leg::setProgramCode()
     * @uses Leg::setProgramSystemCode()
     * @uses Leg::setFareStatus()
     * @uses Leg::setBaseFare()
     * @uses Leg::setEquivFare()
     * @uses Leg::setTaxes()
     * @uses Leg::setTotalFare()
     * @uses Leg::setTotalMileage()
     * @param string $rPH
     * @param string $departureDate
     * @param \Sabre\BargainFinderMax\Structs\DepartureDateTime $departureDateTime
     * @param \Sabre\BargainFinderMax\Structs\GlobalDateTimeType $arrivalDateTime
     * @param \Sabre\BargainFinderMax\Structs\Origins $origins
     * @param \Sabre\BargainFinderMax\Structs\Destinations $destinations
     * @param \Sabre\BargainFinderMax\Structs\ConnectionType $connectionLocations
     * @param \Sabre\BargainFinderMax\Structs\Carriers $carriers
     * @param \Sabre\BargainFinderMax\Structs\Cabin $cabin
     * @param int $maxOptions
     * @param \Sabre\BargainFinderMax\Structs\Segment[] $segment
     * @param string $number
     * @param string $brandID
     * @param string $brandDescription
     * @param string $programName
     * @param string $programID
     * @param string $programCode
     * @param string $programSystemCode
     * @param string $fareStatus
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $baseFare
     * @param \Sabre\BargainFinderMax\Structs\EquivFare $equivFare
     * @param \Sabre\BargainFinderMax\Structs\Taxes $taxes
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $totalFare
     * @param \Sabre\BargainFinderMax\Structs\TotalMileage $totalMileage
     */
    public function __construct($rPH = null, $departureDate = null, \Sabre\BargainFinderMax\Structs\DepartureDateTime $departureDateTime = null, \Sabre\BargainFinderMax\Structs\GlobalDateTimeType $arrivalDateTime = null, \Sabre\BargainFinderMax\Structs\Origins $origins = null, \Sabre\BargainFinderMax\Structs\Destinations $destinations = null, \Sabre\BargainFinderMax\Structs\ConnectionType $connectionLocations = null, \Sabre\BargainFinderMax\Structs\Carriers $carriers = null, \Sabre\BargainFinderMax\Structs\Cabin $cabin = null, $maxOptions = null, array $segment = array(), $number = null, $brandID = null, $brandDescription = null, $programName = null, $programID = null, $programCode = null, $programSystemCode = null, $fareStatus = null, \Sabre\BargainFinderMax\Structs\CurrencyAmountType $baseFare = null, \Sabre\BargainFinderMax\Structs\EquivFare $equivFare = null, \Sabre\BargainFinderMax\Structs\Taxes $taxes = null, \Sabre\BargainFinderMax\Structs\CurrencyAmountType $totalFare = null, \Sabre\BargainFinderMax\Structs\TotalMileage $totalMileage = null)
    {
        $this
            ->setRPH($rPH)
            ->setDepartureDate($departureDate)
            ->setDepartureDateTime($departureDateTime)
            ->setArrivalDateTime($arrivalDateTime)
            ->setOrigins($origins)
            ->setDestinations($destinations)
            ->setConnectionLocations($connectionLocations)
            ->setCarriers($carriers)
            ->setCabin($cabin)
            ->setMaxOptions($maxOptions)
            ->setSegment($segment)
            ->setNumber($number)
            ->setBrandID($brandID)
            ->setBrandDescription($brandDescription)
            ->setProgramName($programName)
            ->setProgramID($programID)
            ->setProgramCode($programCode)
            ->setProgramSystemCode($programSystemCode)
            ->setFareStatus($fareStatus)
            ->setBaseFare($baseFare)
            ->setEquivFare($equivFare)
            ->setTaxes($taxes)
            ->setTotalFare($totalFare)
            ->setTotalMileage($totalMileage);
    }
    /**
     * Get RPH value
     * @return string
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setDepartureDate($departureDate = null)
    {
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return \Sabre\BargainFinderMax\Structs\DepartureDateTime|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param \Sabre\BargainFinderMax\Structs\DepartureDateTime $departureDateTime
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setDepartureDateTime(\Sabre\BargainFinderMax\Structs\DepartureDateTime $departureDateTime = null)
    {
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return \Sabre\BargainFinderMax\Structs\GlobalDateTimeType|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param \Sabre\BargainFinderMax\Structs\GlobalDateTimeType $arrivalDateTime
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setArrivalDateTime(\Sabre\BargainFinderMax\Structs\GlobalDateTimeType $arrivalDateTime = null)
    {
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get Origins value
     * @return \Sabre\BargainFinderMax\Structs\Origins|null
     */
    public function getOrigins()
    {
        return $this->Origins;
    }
    /**
     * Set Origins value
     * @param \Sabre\BargainFinderMax\Structs\Origins $origins
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setOrigins(\Sabre\BargainFinderMax\Structs\Origins $origins = null)
    {
        $this->Origins = $origins;
        return $this;
    }
    /**
     * Get Destinations value
     * @return \Sabre\BargainFinderMax\Structs\Destinations|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @param \Sabre\BargainFinderMax\Structs\Destinations $destinations
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setDestinations(\Sabre\BargainFinderMax\Structs\Destinations $destinations = null)
    {
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Get ConnectionLocations value
     * @return \Sabre\BargainFinderMax\Structs\ConnectionType|null
     */
    public function getConnectionLocations()
    {
        return $this->ConnectionLocations;
    }
    /**
     * Set ConnectionLocations value
     * @param \Sabre\BargainFinderMax\Structs\ConnectionType $connectionLocations
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setConnectionLocations(\Sabre\BargainFinderMax\Structs\ConnectionType $connectionLocations = null)
    {
        $this->ConnectionLocations = $connectionLocations;
        return $this;
    }
    /**
     * Get Carriers value
     * @return \Sabre\BargainFinderMax\Structs\Carriers|null
     */
    public function getCarriers()
    {
        return $this->Carriers;
    }
    /**
     * Set Carriers value
     * @param \Sabre\BargainFinderMax\Structs\Carriers $carriers
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setCarriers(\Sabre\BargainFinderMax\Structs\Carriers $carriers = null)
    {
        $this->Carriers = $carriers;
        return $this;
    }
    /**
     * Get Cabin value
     * @return \Sabre\BargainFinderMax\Structs\Cabin|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @param \Sabre\BargainFinderMax\Structs\Cabin $cabin
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setCabin(\Sabre\BargainFinderMax\Structs\Cabin $cabin = null)
    {
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get MaxOptions value
     * @return int|null
     */
    public function getMaxOptions()
    {
        return $this->MaxOptions;
    }
    /**
     * Set MaxOptions value
     * @param int $maxOptions
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setMaxOptions($maxOptions = null)
    {
        $this->MaxOptions = $maxOptions;
        return $this;
    }
    /**
     * Get Segment value
     * @return \Sabre\BargainFinderMax\Structs\Segment[]|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Segment[] $segment
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setSegment(array $segment = array())
    {
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Add item to Segment value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Segment $item
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function addToSegment(\Sabre\BargainFinderMax\Structs\Segment $item)
    {
        $this->Segment[] = $item;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get BrandID value
     * @return string|null
     */
    public function getBrandID()
    {
        return $this->BrandID;
    }
    /**
     * Set BrandID value
     * @param string $brandID
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setBrandID($brandID = null)
    {
        $this->BrandID = $brandID;
        return $this;
    }
    /**
     * Get BrandDescription value
     * @return string|null
     */
    public function getBrandDescription()
    {
        return $this->BrandDescription;
    }
    /**
     * Set BrandDescription value
     * @param string $brandDescription
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setBrandDescription($brandDescription = null)
    {
        $this->BrandDescription = $brandDescription;
        return $this;
    }
    /**
     * Get ProgramName value
     * @return string|null
     */
    public function getProgramName()
    {
        return $this->ProgramName;
    }
    /**
     * Set ProgramName value
     * @param string $programName
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setProgramName($programName = null)
    {
        $this->ProgramName = $programName;
        return $this;
    }
    /**
     * Get ProgramID value
     * @return string|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setProgramID($programID = null)
    {
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get ProgramCode value
     * @return string|null
     */
    public function getProgramCode()
    {
        return $this->ProgramCode;
    }
    /**
     * Set ProgramCode value
     * @param string $programCode
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setProgramCode($programCode = null)
    {
        $this->ProgramCode = $programCode;
        return $this;
    }
    /**
     * Get ProgramSystemCode value
     * @return string|null
     */
    public function getProgramSystemCode()
    {
        return $this->ProgramSystemCode;
    }
    /**
     * Set ProgramSystemCode value
     * @param string $programSystemCode
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setProgramSystemCode($programSystemCode = null)
    {
        $this->ProgramSystemCode = $programSystemCode;
        return $this;
    }
    /**
     * Get FareStatus value
     * @return string|null
     */
    public function getFareStatus()
    {
        return $this->FareStatus;
    }
    /**
     * Set FareStatus value
     * @param string $fareStatus
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setFareStatus($fareStatus = null)
    {
        $this->FareStatus = $fareStatus;
        return $this;
    }
    /**
     * Get BaseFare value
     * @return \Sabre\BargainFinderMax\Structs\CurrencyAmountType|null
     */
    public function getBaseFare()
    {
        return $this->BaseFare;
    }
    /**
     * Set BaseFare value
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $baseFare
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setBaseFare(\Sabre\BargainFinderMax\Structs\CurrencyAmountType $baseFare = null)
    {
        $this->BaseFare = $baseFare;
        return $this;
    }
    /**
     * Get EquivFare value
     * @return \Sabre\BargainFinderMax\Structs\EquivFare|null
     */
    public function getEquivFare()
    {
        return $this->EquivFare;
    }
    /**
     * Set EquivFare value
     * @param \Sabre\BargainFinderMax\Structs\EquivFare $equivFare
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setEquivFare(\Sabre\BargainFinderMax\Structs\EquivFare $equivFare = null)
    {
        $this->EquivFare = $equivFare;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \Sabre\BargainFinderMax\Structs\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \Sabre\BargainFinderMax\Structs\Taxes $taxes
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setTaxes(\Sabre\BargainFinderMax\Structs\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get TotalFare value
     * @return \Sabre\BargainFinderMax\Structs\CurrencyAmountType|null
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * Set TotalFare value
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $totalFare
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setTotalFare(\Sabre\BargainFinderMax\Structs\CurrencyAmountType $totalFare = null)
    {
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Get TotalMileage value
     * @return \Sabre\BargainFinderMax\Structs\TotalMileage|null
     */
    public function getTotalMileage()
    {
        return $this->TotalMileage;
    }
    /**
     * Set TotalMileage value
     * @param \Sabre\BargainFinderMax\Structs\TotalMileage $totalMileage
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public function setTotalMileage(\Sabre\BargainFinderMax\Structs\TotalMileage $totalMileage = null)
    {
        $this->TotalMileage = $totalMileage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Leg
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
