<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItineraryCache Structs
 * @subpackage Structs
 */
class ItineraryCache extends AbstractStructBase
{
    /**
     * The PublicTimeToLive
     * @var int
     */
    public $PublicTimeToLive;
    /**
     * The RemovePreviousOnUpdate
     * @var bool
     */
    public $RemovePreviousOnUpdate;
    /**
     * Constructor method for ItineraryCache
     * @uses ItineraryCache::setPublicTimeToLive()
     * @uses ItineraryCache::setRemovePreviousOnUpdate()
     * @param int $publicTimeToLive
     * @param bool $removePreviousOnUpdate
     */
    public function __construct($publicTimeToLive = null, $removePreviousOnUpdate = null)
    {
        $this
            ->setPublicTimeToLive($publicTimeToLive)
            ->setRemovePreviousOnUpdate($removePreviousOnUpdate);
    }
    /**
     * Get PublicTimeToLive value
     * @return int|null
     */
    public function getPublicTimeToLive()
    {
        return $this->PublicTimeToLive;
    }
    /**
     * Set PublicTimeToLive value
     * @param int $publicTimeToLive
     * @return \Sabre\BargainFinderMax\Structs\ItineraryCache
     */
    public function setPublicTimeToLive($publicTimeToLive = null)
    {
        $this->PublicTimeToLive = $publicTimeToLive;
        return $this;
    }
    /**
     * Get RemovePreviousOnUpdate value
     * @return bool|null
     */
    public function getRemovePreviousOnUpdate()
    {
        return $this->RemovePreviousOnUpdate;
    }
    /**
     * Set RemovePreviousOnUpdate value
     * @param bool $removePreviousOnUpdate
     * @return \Sabre\BargainFinderMax\Structs\ItineraryCache
     */
    public function setRemovePreviousOnUpdate($removePreviousOnUpdate = null)
    {
        $this->RemovePreviousOnUpdate = $removePreviousOnUpdate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ItineraryCache
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
