<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InboundOutboundPairing Structs
 * Meta informations extracted from the WSDL
 * - documentation: Defines the requested ratio of inbounds to outbounds in the response.
 * - maxInclusive: 1000
 * - minInclusive: 1
 * @subpackage Structs
 */
class InboundOutboundPairing extends AbstractStructBase
{
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxInclusive: 10
     * - minInclusive: 0
     * @var float
     */
    public $Weight;
    /**
     * The Duplicates
     * Meta informations extracted from the WSDL
     * - default: 1
     * @var int
     */
    public $Duplicates;
    /**
     * Constructor method for InboundOutboundPairing
     * @uses InboundOutboundPairing::setWeight()
     * @uses InboundOutboundPairing::setDuplicates()
     * @param float $weight
     * @param int $duplicates
     */
    public function __construct($weight = null, $duplicates = 1)
    {
        $this
            ->setWeight($weight)
            ->setDuplicates($duplicates);
    }
    /**
     * Get Weight value
     * @return float
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \Sabre\BargainFinderMax\Structs\InboundOutboundPairing
     */
    public function setWeight($weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Duplicates value
     * @return int|null
     */
    public function getDuplicates()
    {
        return $this->Duplicates;
    }
    /**
     * Set Duplicates value
     * @param int $duplicates
     * @return \Sabre\BargainFinderMax\Structs\InboundOutboundPairing
     */
    public function setDuplicates($duplicates = 1)
    {
        $this->Duplicates = $duplicates;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\InboundOutboundPairing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
