<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HandlingMarkupDetail Structs
 * @subpackage Structs
 */
class HandlingMarkupDetail extends AbstractStructBase
{
    /**
     * The MarkupHandlingFeeAppID
     * Meta informations extracted from the WSDL
     * - documentation: Markup/Handling fee Application ID
     * - use: optional
     * @var string
     */
    public $MarkupHandlingFeeAppID;
    /**
     * The MarkupTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Markup type code, reserved for future extension
     * - use: optional
     * @var string
     */
    public $MarkupTypeCode;
    /**
     * The FareAmountAfterMarkup
     * Meta informations extracted from the WSDL
     * - documentation: Fare Amount after markup | Used for amounts, max 3 decimals
     * - use: optional
     * - fractionDigits: 3
     * @var float
     */
    public $FareAmountAfterMarkup;
    /**
     * The MarkupAmount
     * Meta informations extracted from the WSDL
     * - documentation: Markup Amount | Used for amounts, max 3 decimals
     * - use: optional
     * - fractionDigits: 3
     * @var float
     */
    public $MarkupAmount;
    /**
     * The AmountCurrency
     * Meta informations extracted from the WSDL
     * - documentation: Markup currency | Used for Currency Codes | Used for Currency Codes | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - use: optional
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $AmountCurrency;
    /**
     * The MarkupRuleSourcePCC
     * Meta informations extracted from the WSDL
     * - documentation: Markup Rule Source PCC
     * - use: optional
     * - pattern: [0-9A-Z]{3,4}
     * @var string
     */
    public $MarkupRuleSourcePCC;
    /**
     * The MarkupRuleItemNumber
     * Meta informations extracted from the WSDL
     * - documentation: Markup Rule Item Number
     * - use: optional
     * @var int
     */
    public $MarkupRuleItemNumber;
    /**
     * The RetailerRuleQualifier
     * Meta informations extracted from the WSDL
     * - documentation: Retailer Rule Qualifier
     * - use: optional
     * - pattern: [0-9A-Za-z]{2,20}
     * @var string
     */
    public $RetailerRuleQualifier;
    /**
     * Constructor method for HandlingMarkupDetail
     * @uses HandlingMarkupDetail::setMarkupHandlingFeeAppID()
     * @uses HandlingMarkupDetail::setMarkupTypeCode()
     * @uses HandlingMarkupDetail::setFareAmountAfterMarkup()
     * @uses HandlingMarkupDetail::setMarkupAmount()
     * @uses HandlingMarkupDetail::setAmountCurrency()
     * @uses HandlingMarkupDetail::setMarkupRuleSourcePCC()
     * @uses HandlingMarkupDetail::setMarkupRuleItemNumber()
     * @uses HandlingMarkupDetail::setRetailerRuleQualifier()
     * @param string $markupHandlingFeeAppID
     * @param string $markupTypeCode
     * @param float $fareAmountAfterMarkup
     * @param float $markupAmount
     * @param string $amountCurrency
     * @param string $markupRuleSourcePCC
     * @param int $markupRuleItemNumber
     * @param string $retailerRuleQualifier
     */
    public function __construct($markupHandlingFeeAppID = null, $markupTypeCode = null, $fareAmountAfterMarkup = null, $markupAmount = null, $amountCurrency = null, $markupRuleSourcePCC = null, $markupRuleItemNumber = null, $retailerRuleQualifier = null)
    {
        $this
            ->setMarkupHandlingFeeAppID($markupHandlingFeeAppID)
            ->setMarkupTypeCode($markupTypeCode)
            ->setFareAmountAfterMarkup($fareAmountAfterMarkup)
            ->setMarkupAmount($markupAmount)
            ->setAmountCurrency($amountCurrency)
            ->setMarkupRuleSourcePCC($markupRuleSourcePCC)
            ->setMarkupRuleItemNumber($markupRuleItemNumber)
            ->setRetailerRuleQualifier($retailerRuleQualifier);
    }
    /**
     * Get MarkupHandlingFeeAppID value
     * @return string|null
     */
    public function getMarkupHandlingFeeAppID()
    {
        return $this->MarkupHandlingFeeAppID;
    }
    /**
     * Set MarkupHandlingFeeAppID value
     * @param string $markupHandlingFeeAppID
     * @return \Sabre\BargainFinderMax\Structs\HandlingMarkupDetail
     */
    public function setMarkupHandlingFeeAppID($markupHandlingFeeAppID = null)
    {
        $this->MarkupHandlingFeeAppID = $markupHandlingFeeAppID;
        return $this;
    }
    /**
     * Get MarkupTypeCode value
     * @return string|null
     */
    public function getMarkupTypeCode()
    {
        return $this->MarkupTypeCode;
    }
    /**
     * Set MarkupTypeCode value
     * @param string $markupTypeCode
     * @return \Sabre\BargainFinderMax\Structs\HandlingMarkupDetail
     */
    public function setMarkupTypeCode($markupTypeCode = null)
    {
        $this->MarkupTypeCode = $markupTypeCode;
        return $this;
    }
    /**
     * Get FareAmountAfterMarkup value
     * @return float|null
     */
    public function getFareAmountAfterMarkup()
    {
        return $this->FareAmountAfterMarkup;
    }
    /**
     * Set FareAmountAfterMarkup value
     * @param float $fareAmountAfterMarkup
     * @return \Sabre\BargainFinderMax\Structs\HandlingMarkupDetail
     */
    public function setFareAmountAfterMarkup($fareAmountAfterMarkup = null)
    {
        $this->FareAmountAfterMarkup = $fareAmountAfterMarkup;
        return $this;
    }
    /**
     * Get MarkupAmount value
     * @return float|null
     */
    public function getMarkupAmount()
    {
        return $this->MarkupAmount;
    }
    /**
     * Set MarkupAmount value
     * @param float $markupAmount
     * @return \Sabre\BargainFinderMax\Structs\HandlingMarkupDetail
     */
    public function setMarkupAmount($markupAmount = null)
    {
        $this->MarkupAmount = $markupAmount;
        return $this;
    }
    /**
     * Get AmountCurrency value
     * @return string|null
     */
    public function getAmountCurrency()
    {
        return $this->AmountCurrency;
    }
    /**
     * Set AmountCurrency value
     * @param string $amountCurrency
     * @return \Sabre\BargainFinderMax\Structs\HandlingMarkupDetail
     */
    public function setAmountCurrency($amountCurrency = null)
    {
        $this->AmountCurrency = $amountCurrency;
        return $this;
    }
    /**
     * Get MarkupRuleSourcePCC value
     * @return string|null
     */
    public function getMarkupRuleSourcePCC()
    {
        return $this->MarkupRuleSourcePCC;
    }
    /**
     * Set MarkupRuleSourcePCC value
     * @param string $markupRuleSourcePCC
     * @return \Sabre\BargainFinderMax\Structs\HandlingMarkupDetail
     */
    public function setMarkupRuleSourcePCC($markupRuleSourcePCC = null)
    {
        $this->MarkupRuleSourcePCC = $markupRuleSourcePCC;
        return $this;
    }
    /**
     * Get MarkupRuleItemNumber value
     * @return int|null
     */
    public function getMarkupRuleItemNumber()
    {
        return $this->MarkupRuleItemNumber;
    }
    /**
     * Set MarkupRuleItemNumber value
     * @param int $markupRuleItemNumber
     * @return \Sabre\BargainFinderMax\Structs\HandlingMarkupDetail
     */
    public function setMarkupRuleItemNumber($markupRuleItemNumber = null)
    {
        $this->MarkupRuleItemNumber = $markupRuleItemNumber;
        return $this;
    }
    /**
     * Get RetailerRuleQualifier value
     * @return string|null
     */
    public function getRetailerRuleQualifier()
    {
        return $this->RetailerRuleQualifier;
    }
    /**
     * Set RetailerRuleQualifier value
     * @param string $retailerRuleQualifier
     * @return \Sabre\BargainFinderMax\Structs\HandlingMarkupDetail
     */
    public function setRetailerRuleQualifier($retailerRuleQualifier = null)
    {
        $this->RetailerRuleQualifier = $retailerRuleQualifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\HandlingMarkupDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
