<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupDescriptionType Structs
 * @subpackage Structs
 */
class GroupDescriptionType extends AbstractStructBase
{
    /**
     * The LegDescription
     * Meta informations extracted from the WSDL
     * - documentation: Leg description
     * - maxOccurs: unbounded
     * @var \Sabre\BargainFinderMax\Structs\LegDescriptionType[]
     */
    public $LegDescription;
    /**
     * The ItineraryType
     * Meta informations extracted from the WSDL
     * - documentation: Indicates what type of itineraries is contained in this itinerary group. If this attribute is missing, it denotes "normal" itineraries. Apart from normal itineraries, this attribute can name one of the following types:- "branded"-
     * "oneWay"- "departed"- "soldOut"- "legMissed"No other value shall appear in this attribute at this time. Other values may be allowed in the future.
     * - use: optional
     * @var string
     */
    public $ItineraryType;
    /**
     * Constructor method for GroupDescriptionType
     * @uses GroupDescriptionType::setLegDescription()
     * @uses GroupDescriptionType::setItineraryType()
     * @param \Sabre\BargainFinderMax\Structs\LegDescriptionType[] $legDescription
     * @param string $itineraryType
     */
    public function __construct(array $legDescription = array(), $itineraryType = null)
    {
        $this
            ->setLegDescription($legDescription)
            ->setItineraryType($itineraryType);
    }
    /**
     * Get LegDescription value
     * @return \Sabre\BargainFinderMax\Structs\LegDescriptionType[]|null
     */
    public function getLegDescription()
    {
        return $this->LegDescription;
    }
    /**
     * Set LegDescription value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\LegDescriptionType[] $legDescription
     * @return \Sabre\BargainFinderMax\Structs\GroupDescriptionType
     */
    public function setLegDescription(array $legDescription = array())
    {
        $this->LegDescription = $legDescription;
        return $this;
    }
    /**
     * Add item to LegDescription value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\LegDescriptionType $item
     * @return \Sabre\BargainFinderMax\Structs\GroupDescriptionType
     */
    public function addToLegDescription(\Sabre\BargainFinderMax\Structs\LegDescriptionType $item)
    {
        $this->LegDescription[] = $item;
        return $this;
    }
    /**
     * Get ItineraryType value
     * @return string|null
     */
    public function getItineraryType()
    {
        return $this->ItineraryType;
    }
    /**
     * Set ItineraryType value
     * @param string $itineraryType
     * @return \Sabre\BargainFinderMax\Structs\GroupDescriptionType
     */
    public function setItineraryType($itineraryType = null)
    {
        $this->ItineraryType = $itineraryType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\GroupDescriptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
